/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GConstants;
import guicomponents.GMessenger;
import guicomponents.GWinApplet;
import guicomponents.GWinData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PImage;

public class GWindow
extends Frame
implements GConstants {
    protected PApplet app;
    public GWinApplet papplet;
    public GWinApplet embed;
    protected String winName;
    public GWinData data;
    protected WindowAdapter winAdapt = null;
    protected int actionOnClose = 3843;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;
    protected boolean regPost = false;
    protected Object preHandlerObject = null;
    protected Method preHandlerMethod = null;
    protected String preHandlerMethodName;
    protected Object drawHandlerObject = null;
    protected Method drawHandlerMethod = null;
    protected String drawHandlerMethodName;
    protected Object mouseHandlerObject = null;
    protected Method mouseHandlerMethod = null;
    protected String mouseHandlerMethodName;
    protected Object postHandlerObject = null;
    protected Method postHandlerMethod = null;
    protected String postHandlerMethodName;

    public GWindow(PApplet theApplet, String name, int x, int y, int w, int h, boolean noFrame, String mode) {
        super(name);
        this.app = theApplet;
        this.winName = name;
        if (mode == null || mode.equals("")) {
            mode = "processing.core.PGraphicsJava2D";
        }
        this.embed = this.papplet = new GWinApplet(mode);
        this.papplet.owner = this;
        this.papplet.frame = this;
        this.papplet.frame.setResizable(true);
        this.papplet.appWidth = w;
        this.papplet.appHeight = h;
        this.windowCtorCore(x, y, w, h, noFrame, mode);
        super.setResizable(true);
    }

    public GWindow(PApplet theApplet, String name, int x, int y, PImage image, boolean noFrame, String mode) {
        super(name);
        this.app = theApplet;
        this.winName = name;
        if (mode == null || mode.equals("")) {
            mode = "processing.core.PGraphicsJava2D";
        }
        this.embed = this.papplet = new GWinApplet(mode);
        this.papplet.owner = this;
        this.papplet.frame = this;
        this.papplet.frame.setResizable(true);
        this.papplet.bkImage = image;
        this.papplet.appWidth = image.width;
        this.papplet.appHeight = image.height;
        this.windowCtorCore(x, y, image.width, image.height, noFrame, mode);
        super.setResizable(false);
    }

    private void windowCtorCore(int x, int y, int w, int h, boolean noFrame, String mode) {
        this.papplet.bkColor = this.papplet.color(0);
        this.papplet.resize(this.papplet.appWidth, this.papplet.appHeight);
        this.papplet.setPreferredSize(new Dimension(this.papplet.appWidth, this.papplet.appHeight));
        this.papplet.setMinimumSize(new Dimension(this.papplet.appWidth, this.papplet.appHeight));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.papplet), "Center");
        this.papplet.init();
        this.setUndecorated(noFrame);
        this.pack();
        this.setLocation(x, y);
        this.setVisible(true);
        this.papplet.registerDraw(this.papplet);
        this.regDraw = true;
        this.setOnTop(true);
        this.data = new GWinData();
        this.data.owner = this;
        G4P.addWindow(this);
    }

    public void add(GComponent component) {
        component.changeWindow(this.papplet);
    }

    public void addData(GWinData data) {
        this.data = data;
        this.data.owner = this;
    }

    public void setOnTop(boolean onTop) {
        block2: {
            try {
                this.setAlwaysOnTop(onTop);
            }
            catch (Exception e) {
                if (!G4P.messages) break block2;
                System.out.println("Warning: setOnTop() method will not work when the sketch is run from a remote location.");
            }
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void setResizable(boolean resizable) {
        if (!resizable) {
            super.setResizable(false);
        } else if (this.papplet.bkImage == null) {
            super.setResizable(true);
        }
    }

    public void setBackground(PImage image) {
        this.papplet.noLoop();
        this.papplet.bkImage = null;
        super.setResizable(true);
        this.papplet.resize(image.width, image.height);
        this.papplet.bkImage = image;
        this.papplet.appWidth = image.width;
        this.papplet.appHeight = image.height;
        this.papplet.setPreferredSize(new Dimension(this.papplet.appWidth, this.papplet.appHeight));
        this.papplet.setMinimumSize(new Dimension(this.papplet.appWidth, this.papplet.appHeight));
        this.pack();
        super.setResizable(false);
        this.papplet.loop();
    }

    public void setBackground(int col) {
        this.papplet.bkColor = col;
    }

    public void setAutoClear(boolean auto_clear) {
        this.papplet.autoClear = auto_clear;
    }

    public void setActionOnClose(int action) {
        switch (action) {
            case 3843: {
                this.removeWindowListener(this.winAdapt);
                this.winAdapt = null;
                this.actionOnClose = action;
                break;
            }
            case 3841: 
            case 3842: {
                if (this.winAdapt == null) {
                    this.winAdapt = new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent evt) {
                            switch (GWindow.this.actionOnClose) {
                                case 3842: {
                                    GWindow.this.removeFromG4P();
                                    GWindow.this.dispose();
                                    break;
                                }
                                case 3841: {
                                    System.exit(0);
                                }
                            }
                        }
                    };
                    this.addWindowListener(this.winAdapt);
                }
                this.actionOnClose = action;
            }
        }
    }

    public int getActionOnClose() {
        return this.actionOnClose;
    }

    public void close() {
        this.removeFromG4P();
        this.dispose();
    }

    private void removeFromG4P() {
        this.papplet.noLoop();
        this.papplet.unregisterPost(this.papplet);
        if (this.regDraw) {
            this.papplet.unregisterDraw(this.papplet);
        }
        if (this.regPre) {
            this.papplet.unregisterPre(this.papplet);
        }
        if (this.regMouse) {
            this.papplet.unregisterMouseEvent(this.papplet);
        }
        this.regMouse = false;
        this.regPre = false;
        this.regDraw = false;
        G4P.removeWindow(this);
    }

    public void addDrawHandler(Object obj, String methodName) {
        try {
            this.drawHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.drawHandlerObject = obj;
            this.drawHandlerMethodName = methodName;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{GWinApplet.class, GWinData.class}});
        }
    }

    public void addPreHandler(Object obj, String methodName) {
        try {
            this.preHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.preHandlerObject = obj;
            this.preHandlerMethodName = methodName;
            this.papplet.registerPre(this.papplet);
            this.regPre = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{GWinApplet.class, GWinData.class}});
        }
    }

    public void addMouseHandler(Object obj, String methodName) {
        try {
            this.mouseHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class, MouseEvent.class);
            this.mouseHandlerObject = obj;
            this.mouseHandlerMethodName = methodName;
            this.papplet.registerMouseEvent(this.papplet);
            this.regMouse = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{GWinApplet.class, GWinData.class, MouseEvent.class}});
        }
    }

    public void addPostHandler(Object obj, String methodName) {
        try {
            this.postHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.postHandlerObject = obj;
            this.postHandlerMethodName = methodName;
            this.regPost = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{GWinApplet.class, GWinData.class}});
        }
    }
}

