/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GComponent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GRoundControl
extends GComponent {
    protected int cx;
    protected int cy;
    protected float start;
    protected float end;
    protected int sizeRadX;
    protected int sizeRadY;
    protected boolean overRotArcOnly = false;
    protected int aLow;
    protected int aHigh;
    public boolean wrap0;
    public int needleAngle;
    public int lastTargetNeedleAngle;
    public int targetNeedleAngle;
    protected int needleDir;
    protected int mouseAngle;
    protected int lastMouseAngle;
    protected int offset;
    protected float valueStart = 20.0f;
    protected float valueEnd = 270.0f;
    protected float value = 300.0f;
    protected boolean isValueChanging;
    protected boolean clockwiseValues = this.valueStart < this.valueEnd;
    protected int inertia = 1;
    protected int mode = 1282;
    protected float sensitivity = 1.0f;
    protected int startMouseX;
    protected int startMouseY;

    public GRoundControl(PApplet theApplet, int x, int y, int width, int height, int arcStart, int arcEnd) {
        super(theApplet, x, y);
        this.width = width < 20 ? 20 : width;
        this.height = height < 20 ? 20 : height;
        this.sizeRadX = this.cx = this.width / 2;
        this.sizeRadY = this.cy = this.height / 2;
        this.aLow = this.getValidArcAngle(arcStart);
        this.aHigh = this.getValidArcAngle(arcEnd);
        this.wrap0 = arcStart > arcEnd;
        this.aLow = this.aLow >= this.aHigh ? this.aLow - 360 : this.aLow;
        this.start = PApplet.radians((float)this.aLow);
        this.end = PApplet.radians((float)this.aHigh);
        this.z = 24;
        this.registerAutos_DMPK(true, true, true, false);
        this.setLimits(50.0f, 0.0f, 100.0f);
    }

    public GRoundControl(PApplet theApplet, int x, int y, int size, int arcStart, int arcEnd) {
        this(theApplet, x, y, size, size, arcStart, arcEnd);
    }

    @Override
    public void pre() {
        int nInertia = this.inertia;
        if (this.needleAngle == this.targetNeedleAngle) {
            this.isValueChanging = false;
            this.needleDir = 0;
        } else {
            int change;
            while ((change = (this.targetNeedleAngle - this.needleAngle) / nInertia) == 0 && --nInertia > 0) {
            }
            this.needleDir = this.signInt(change);
            if (change != 0) {
                this.needleAngle += change;
                this.isValueChanging = true;
                this.fireEvent();
            } else {
                this.isValueChanging = false;
            }
        }
    }

    @Override
    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        p.x += this.cx;
        p.y += this.cy;
        int degs = 0;
        boolean mouseOver = this.overRotArcOnly ? this.isOverRotArc(this.winApp.mouseX, this.winApp.mouseY) : this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver || this.z <= GRoundControl.focusObjectZ()) break;
                this.startMouseX = this.winApp.mouseX - p.x;
                this.startMouseY = this.winApp.mouseY - p.y;
                degs = this.getAngleFromUser(p);
                this.mouseAngle = degs < 0 ? degs + 360 : degs;
                this.lastMouseAngle = this.mouseAngle;
                this.offset = this.targetNeedleAngle - this.mouseAngle;
                this.takeFocus();
                break;
            }
            case 502: {
                if (focusIsWith == this) {
                    this.loseFocus(null);
                }
                this.lastTargetNeedleAngle = this.targetNeedleAngle;
                break;
            }
            case 500: {
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                degs = this.getAngleFromUser(p);
                int n = this.mouseAngle = degs < 0 ? degs + 360 : degs;
                if (this.mouseAngle != this.lastMouseAngle) {
                    int deltaMangle = this.mouseAngle - this.lastMouseAngle;
                    if (deltaMangle < -180) {
                        deltaMangle += 360;
                    } else if (deltaMangle > 180) {
                        deltaMangle -= 360;
                    }
                    this.targetNeedleAngle = PApplet.constrain((int)(this.targetNeedleAngle + deltaMangle), (int)this.aLow, (int)this.aHigh);
                    this.offset += this.targetNeedleAngle - this.lastTargetNeedleAngle - deltaMangle;
                    this.lastTargetNeedleAngle = this.targetNeedleAngle;
                    this.lastMouseAngle = this.mouseAngle;
                }
                this.isValueChanging = true;
            }
        }
    }

    public abstract boolean isOverRotArc(int var1, int var2);

    protected int getAngleFromUser(Point p) {
        int degs = 0;
        switch (this.mode) {
            case 1281: {
                degs = Math.round(PApplet.degrees((float)this.calcRealAngleFromXY(p, this.winApp.mouseX, this.winApp.mouseY)));
                break;
            }
            case 1282: {
                degs = (int)(this.sensitivity * (float)(this.winApp.mouseX - p.x - this.startMouseX));
                break;
            }
            case 1283: {
                degs = (int)(this.sensitivity * (float)(this.winApp.mouseY - p.y - this.startMouseY));
            }
        }
        return degs;
    }

    protected float calcRealAngleFromXY(Point p, float x, float y) {
        float rads = (float)Math.atan2(y - (float)p.y, x - (float)p.x);
        rads = rads < 0.0f ? rads + (float)Math.PI * 2 : rads;
        return rads;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public int getControlMode() {
        return this.mode;
    }

    public void setControlMode(int mode) {
        this.mode = mode;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity < 0.1f ? 0.1f : sensitivity;
    }

    public int getInertia() {
        return this.inertia;
    }

    public void setInertia(int inertia) {
        if (inertia >= 1) {
            this.inertia = inertia;
        }
    }

    public boolean isMouseORA() {
        return this.overRotArcOnly;
    }

    public void setMouseORA(boolean overRotArcOnly) {
        this.overRotArcOnly = overRotArcOnly;
    }

    public float getValuef() {
        if (this.clockwiseValues) {
            return PApplet.map((float)this.needleAngle, (float)this.aLow, (float)this.aHigh, (float)this.valueStart, (float)this.valueEnd);
        }
        return -PApplet.map((float)this.needleAngle, (float)this.aLow, (float)this.aHigh, (float)(-this.valueStart), (float)(-this.valueEnd));
    }

    public int getValue() {
        return Math.round(this.getValuef());
    }

    public void setLimits(float init, float start, float end) {
        this.valueStart = start;
        this.valueEnd = end;
        this.clockwiseValues = start < end;
        this.setValue(init, true);
    }

    public void setValue(float newValue) {
        newValue = this.clockwiseValues ? PApplet.constrain((float)newValue, (float)this.valueStart, (float)this.valueEnd) : PApplet.constrain((float)newValue, (float)this.valueEnd, (float)this.valueStart);
        this.targetNeedleAngle = this.getAngleFromValue(newValue);
    }

    public void setValue(float newValue, boolean ignoreInteria) {
        this.setValue(newValue);
        if (ignoreInteria) {
            this.needleAngle = this.targetNeedleAngle;
        }
    }

    protected int getAngleFromValue(float value) {
        int angle = this.clockwiseValues ? (int)PApplet.map((float)value, (float)this.valueStart, (float)this.valueEnd, (float)this.aLow, (float)this.aHigh) : (int)PApplet.map((float)(-value), (float)(-this.valueStart), (float)(-this.valueEnd), (float)this.aLow, (float)this.aHigh);
        return angle;
    }

    protected boolean isInValidArc(int angle) {
        return this.aLow < 0 ? angle >= 360 + this.aLow || angle <= this.aHigh : angle >= this.aLow && angle <= this.aHigh;
    }

    protected int getValidArcAngle(int angle) {
        while (angle < 0) {
            angle += 360;
        }
        while (angle > 360) {
            angle -= 360;
        }
        return angle;
    }

    protected int signInt(int n) {
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    protected float convertRealAngleToOvalAngle(double ra, float rX, float rY) {
        double cosA = Math.cos(ra);
        double sinA = Math.sin(ra);
        double h = (double)Math.abs(rX - rY) / 2.0;
        double eX = (double)rX * cosA;
        double eY = (double)rY * sinA;
        if (rX > rY) {
            eX -= h * cosA;
            eY += h * sinA;
        } else {
            eX += h * cosA;
            eY -= h * sinA;
        }
        float angle = (float)Math.atan2(eY, eX);
        while (ra - (double)angle >= 3.1415927410125732) {
            angle += (float)Math.PI * 2;
        }
        while ((double)angle - ra >= 3.1415927410125732) {
            angle -= (float)Math.PI * 2;
        }
        return angle;
    }

    protected void calcCircumferencePosition(Point circPos, float xp, float yp, float rX, float rY) {
        double numer = rX * rY;
        double denom = (float)Math.sqrt(rX * rX * yp * yp + rY * rY * xp * xp);
        circPos.x = (int)Math.round((double)xp * numer / denom);
        circPos.y = (int)Math.round((double)yp * numer / denom);
    }
}

