/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;

public class GPanel
extends GComponent {
    protected boolean tabOnly = true;
    protected int tabHeight;
    protected int dockX;
    protected int dockY;
    protected boolean beingDragged = false;

    public GPanel(PApplet theApplet, String text, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.panelCtorCore(text, width, height);
    }

    private void panelCtorCore(String text, int width, int height) {
        this.children = new HashSet();
        this.setText(text);
        this.tabHeight = (int)(1.2f * (float)this.localFont.getFont().getSize() + 4.0f);
        this.constrainPanelPosition();
        this.opaque = true;
        this.dockX = this.x;
        this.dockY = this.y;
        this.width = width;
        this.height = height;
        this.z = 32;
        this.createEventHandler(this.winApp, "handlePanelEvents", new Class[]{GPanel.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    @Override
    public void setFont(String fontname, int fontsize) {
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        this.tabHeight = (int)(1.2f * (float)this.localFont.getFont().getSize() + 4.0f);
        this.setText(this.text);
    }

    @Override
    protected void loseFocus(GComponent grabber) {
        focusIsWith = null;
        this.beingDragged = false;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.pushMatrix();
        this.winApp.translate((float)pos.x, (float)pos.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.noStroke();
        if (this.border > 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.pnlBorder);
        }
        this.winApp.fill(this.localColor.pnlTabBack);
        int w = this.tabOnly ? this.textWidth + 16 : this.width;
        this.winApp.rect(0.0f, (float)(-this.tabHeight), (float)w, (float)this.tabHeight);
        this.winApp.fill(this.localColor.pnlFont);
        this.winApp.textFont(this.localFont, (float)this.localFont.getFont().getSize());
        this.winApp.text(this.text, 4.0f, (float)(-(this.tabHeight + this.localFont.getFont().getSize()) / 2 - 2), (float)this.textWidth, (float)this.tabHeight);
        if (!this.tabOnly && this.opaque) {
            this.winApp.fill(this.localColor.pnlBack);
            this.winApp.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
        if (!this.tabOnly) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ((GComponent)iter.next()).draw();
            }
        }
    }

    @Override
    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver || this.z <= GPanel.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                this.beingDragged = true;
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.tabOnly = !this.tabOnly;
                this.eventType = this.tabOnly ? 513 : 514;
                this.fireEvent();
                if (this.tabOnly) {
                    this.x = this.dockX;
                    this.y = this.dockY;
                } else {
                    this.dockX = this.x;
                    this.dockY = this.y;
                    if (this.y + this.height > this.winApp.getHeight()) {
                        this.y = this.winApp.getHeight() - this.height;
                    }
                    if (this.x + this.width > this.winApp.getWidth()) {
                        this.x = this.winApp.getWidth() - this.width;
                    }
                }
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                this.loseFocus(null);
                break;
            }
            case 506: {
                if (focusIsWith != this || this.parent != null) break;
                this.x += this.winApp.mouseX - this.winApp.pmouseX;
                this.y += this.winApp.mouseY - this.winApp.pmouseY;
                this.beingDragged = true;
                this.eventType = 515;
                this.fireEvent();
                this.constrainPanelPosition();
                if (this.tabOnly) break;
                this.dockX = this.x;
                this.dockY = this.y;
            }
        }
    }

    public boolean isDragging() {
        return this.beingDragged;
    }

    private void constrainPanelPosition() {
        int h;
        int w = this.tabOnly ? this.textWidth + 8 : this.width;
        int n = h = this.tabOnly ? 0 : this.height;
        if (this.x < 0) {
            this.x = 0;
        } else if (this.x + w > this.winApp.getWidth()) {
            this.x = this.winApp.getWidth() - w;
        }
        if (this.y - this.tabHeight < 0) {
            this.y = this.tabHeight;
        } else if (this.y + h > this.winApp.getHeight()) {
            this.y = this.winApp.getHeight() - h;
        }
    }

    @Override
    public boolean isOver(int ax, int ay) {
        int w;
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        int n = w = this.tabOnly ? this.textWidth + 8 : this.width;
        return ax >= p.x && ax <= p.x + w && ay >= p.y - this.tabHeight && ay <= p.y;
    }

    public boolean isOverPanel(int ax, int ay) {
        if (this.tabOnly) {
            return this.isOver(ax, ay);
        }
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        return ax >= p.x && ax <= p.x + this.width && ay >= p.y - this.tabHeight && ay <= p.y + this.height;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setAlpha(int alpha) {
        this.localColor.setAlpha(alpha);
        if (!this.children.isEmpty()) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ((GComponent)iter.next()).setAlpha(alpha);
            }
        }
    }

    public void setCollapsed(boolean collapse) {
        this.tabOnly = collapse;
        if (!this.tabOnly) {
            this.constrainPanelPosition();
        }
    }

    public boolean isCollapsed() {
        return this.tabOnly;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }
}

