/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GKnob;
import java.awt.Point;
import processing.core.PApplet;

public class GKnobOval
extends GKnob {
    protected Point p = new Point();

    public GKnobOval(PApplet theApplet, int x, int y, int width, int height, int arcStart, int arcEnd) {
        super(theApplet, x, y, width, height, arcStart, arcEnd);
        this.start = this.convertRealAngleToOvalAngle(PApplet.radians((float)this.aLow), this.sizeRadX, this.sizeRadY);
        this.end = this.convertRealAngleToOvalAngle(PApplet.radians((float)this.aHigh), this.sizeRadX, this.sizeRadY);
        this.calcTickMarkerPositions(this.nbrTickMarks);
    }

    @Override
    public void draw() {
        float nrad;
        if (!this.visible) {
            return;
        }
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        this.p.x += this.cx;
        this.p.y += this.cy;
        float rad = PApplet.radians((float)this.needleAngle);
        this.winApp.pushMatrix();
        this.winApp.translate((float)this.p.x, (float)this.p.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        if (this.bezelWidth > 0) {
            this.winApp.noStroke();
            if (this.rotArcOnly) {
                this.winApp.fill(this.winApp.color(128, 128));
            } else {
                this.winApp.fill(this.winApp.color(128, 48));
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.sizeRadX), (float)(2 * this.sizeRadY));
                this.winApp.fill(this.winApp.color(128, 80));
            }
            this.winApp.arc(0.0f, 0.0f, (float)(2 * this.sizeRadX), (float)(2 * this.sizeRadY), this.start, this.end);
            if (this.valueTrackVisible) {
                this.winApp.fill(this.localColor.knobTrack);
                this.winApp.noStroke();
                nrad = this.convertRealAngleToOvalAngle(rad, this.sizeRadX, this.sizeRadY);
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.barRadX), (float)(2 * this.barRadY), this.start, nrad);
            }
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.stroke(1.2f);
            int i = 0;
            while (i < this.mark.length) {
                if (i == 0 || i == this.mark.length - 1) {
                    this.winApp.strokeWeight(1.5f);
                } else {
                    this.winApp.strokeWeight(1.2f);
                }
                this.winApp.line((float)this.mark[i][0].x, (float)this.mark[i][0].y, (float)this.mark[i][1].x, (float)this.mark[i][1].y);
                ++i;
            }
        }
        if (this.knobRadX > 0) {
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            this.winApp.fill(this.localColor.knobFill);
            if (this.rotArcOnly) {
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY), this.start, this.end);
                this.winApp.stroke(this.localColor.knobBorder);
                this.winApp.strokeWeight(1.2f);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[0][0].x, (float)this.mark[0][0].y);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[this.mark.length - 1][0].x, (float)this.mark[this.mark.length - 1][0].y);
            } else {
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY));
            }
            this.winApp.stroke(this.localColor.knobNeedle);
            this.winApp.strokeWeight(2.0f);
            nrad = this.convertRealAngleToOvalAngle(rad, this.sizeRadX, this.sizeRadY);
            float ox = (float)((double)this.sizeRadX * Math.cos(nrad));
            float oy = (float)((double)this.sizeRadY * Math.sin(nrad));
            this.calcCircumferencePosition(this.p, ox, oy, this.knobRadX, this.knobRadY);
            this.winApp.line(0.0f, 0.0f, (float)this.p.x, (float)this.p.y);
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
    }

    @Override
    public boolean isOver(int ax, int ay) {
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        int dx = ax - this.p.x - this.cx;
        int dy = ay - this.p.y - this.cy;
        float ratioX = (float)dx / (float)this.sizeRadX;
        float ratioY = (float)dy / (float)this.sizeRadY;
        boolean inside = ratioX * ratioX + ratioY * ratioY < 1.0f;
        return inside;
    }

    @Override
    public boolean isOverRotArc(int ax, int ay) {
        boolean inside;
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        int dx = ax - this.p.x - this.cx;
        int dy = ay - this.p.y - this.cy;
        float ratioX = (float)dx / (float)this.sizeRadX;
        float ratioY = (float)dy / (float)this.sizeRadY;
        boolean bl = inside = ratioX * ratioX + ratioY * ratioY < 1.0f;
        if (inside) {
            Point pm = new Point(Math.round(dx), Math.round(dy));
            float eX = pm.x;
            float eY = pm.y;
            this.calcCircumferencePosition(pm, eX, eY, this.sizeRadX, this.sizeRadY);
            double angle = Math.atan2(dy, dx);
            double cosA = Math.cos(angle);
            double sinA = Math.sin(angle);
            double h = (double)Math.abs(this.sizeRadX - this.sizeRadY) / 2.0;
            if (this.width > this.height) {
                eX = (float)((double)eX - h * cosA);
                eY = (float)((double)eY + h * sinA);
            } else {
                eX = (float)((double)eX + h * cosA);
                eY = (float)((double)eY - h * sinA);
            }
            int degs = Math.round(PApplet.degrees((float)((float)Math.atan2(eY, eX))));
            degs = degs < 0 ? degs + 360 : degs;
            inside = this.isInValidArc(degs);
        }
        return inside;
    }

    @Override
    protected void calcTickMarkerPositions(int nticks) {
        this.mark = new Point[nticks][2];
        float ang = PApplet.radians((float)this.aLow);
        float deltaAng = PApplet.radians((float)(this.aHigh - this.aLow)) / (float)(nticks - 1);
        int i = 0;
        while (i < nticks) {
            this.mark[i][0] = new Point();
            this.mark[i][1] = new Point();
            float dang = this.convertRealAngleToOvalAngle(ang, this.sizeRadX, this.sizeRadY);
            float ox = (float)((double)this.sizeRadX * Math.cos(dang));
            float oy = (float)((double)this.sizeRadY * Math.sin(dang));
            this.calcCircumferencePosition(this.mark[i][0], ox, oy, this.knobRadX, this.knobRadY);
            if (i == 0 || i == nticks - 1) {
                this.mark[i][1].x = Math.round(ox);
                this.mark[i][1].y = Math.round(oy);
            } else {
                this.calcCircumferencePosition(this.mark[i][1], ox, oy, this.barRadX, this.barRadY);
            }
            ang += deltaAng;
            ++i;
        }
        this.nbrTickMarks = nticks;
    }
}

