/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GRoundControl;
import java.awt.Point;
import processing.core.PApplet;

public class GKnob
extends GRoundControl {
    protected int nbrTickMarks = 2;
    protected Point[][] mark;
    protected int bezelWidth = Math.max(Math.min(this.sizeRadX, this.sizeRadY) / 3, 4);
    protected int knobRadX;
    protected int knobRadY;
    protected int barRadX;
    protected int barRadY;
    protected boolean valueTrackVisible = true;
    protected boolean rotArcOnly = false;

    protected GKnob(PApplet theApplet, int x, int y, int width, int height, int arcStart, int arcEnd) {
        super(theApplet, x, y, width, height, arcStart, arcEnd);
        this.calculateSizes(this.bezelWidth);
        this.calcTickMarkerPositions(this.nbrTickMarks);
        this.createEventHandler(this.winApp, "handleKnobEvents", new Class[]{GKnob.class});
    }

    public GKnob(PApplet theApplet, int x, int y, int size, int arcStart, int arcEnd) {
        this(theApplet, x, y, size, size, arcStart, arcEnd);
    }

    protected void calculateSizes(int bw) {
        this.bezelWidth = PApplet.constrain((int)bw, (int)0, (int)Math.min(this.sizeRadX, this.sizeRadY));
        this.knobRadX = this.sizeRadX - this.bezelWidth;
        this.knobRadY = this.sizeRadY - this.bezelWidth;
        if (this.knobRadX <= 0 || this.knobRadY <= 0) {
            this.knobRadY = 0;
            this.knobRadX = 0;
            int inset = Math.min(Math.round(0.2f * (float)this.bezelWidth), 10);
            this.barRadX = this.sizeRadX - inset;
            this.barRadY = this.sizeRadY - inset;
        } else {
            this.barRadX = Math.round(0.5f * (float)(this.sizeRadX + this.knobRadX));
            this.barRadY = Math.round(0.5f * (float)(this.sizeRadY + this.knobRadY));
        }
    }

    protected void calcTickMarkerPositions(int nticks) {
        this.mark = new Point[nticks][2];
        int i = 0;
        while (i < nticks) {
            this.mark[i][0] = new Point();
            this.mark[i][1] = new Point();
            ++i;
        }
        float deltaAng = (float)(this.aHigh - this.aLow) / (float)(nticks - 1);
        int i2 = 0;
        while (i2 < nticks) {
            float cosine = (float)Math.cos(PApplet.radians((float)((float)this.aLow + (float)i2 * deltaAng)));
            float sine = (float)Math.sin(PApplet.radians((float)((float)this.aLow + (float)i2 * deltaAng)));
            this.mark[i2][0].x = Math.round((float)this.knobRadX * cosine);
            this.mark[i2][0].y = Math.round((float)this.knobRadY * sine);
            if (i2 == 0 || i2 == nticks - 1) {
                this.mark[i2][1].x = Math.round((float)this.sizeRadX * cosine);
                this.mark[i2][1].y = Math.round((float)this.sizeRadY * sine);
            } else {
                this.mark[i2][1].x = Math.round((float)this.barRadX * cosine);
                this.mark[i2][1].y = Math.round((float)this.barRadY * sine);
            }
            ++i2;
        }
        this.nbrTickMarks = nticks;
    }

    public void setBezelWidth(int bw) {
        this.calculateSizes(bw);
        this.calcTickMarkerPositions(this.nbrTickMarks);
    }

    public int getBezelWidth() {
        return this.bezelWidth;
    }

    public void setValueTrackVisible(boolean visible) {
        this.valueTrackVisible = visible;
    }

    public boolean isValueTrackVisible() {
        return this.valueTrackVisible;
    }

    public void setNbrTickSpaces(int nbr_spaces) {
        this.setNbrTickMarks(nbr_spaces + 1);
    }

    public void setNbrTickMarks(int nbr_ticks) {
        nbr_ticks = nbr_ticks < 2 ? 2 : nbr_ticks;
        this.calcTickMarkerPositions(nbr_ticks);
    }

    @Override
    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        int dx = ax - p.x - this.cx;
        int dy = ay - p.y - this.cy;
        boolean inside = dx * dx + dy * dy < this.sizeRadX * this.sizeRadY;
        return inside;
    }

    @Override
    public boolean isOverRotArc(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        p.x += this.cx;
        p.y += this.cy;
        boolean inside = false;
        int dx = ax - p.x;
        int dy = ay - p.y;
        boolean bl = inside = dx * dx + dy * dy < this.sizeRadX * this.sizeRadY;
        if (inside) {
            int degs = Math.round(PApplet.degrees((float)this.calcRealAngleFromXY(p, ax, ay)));
            inside = this.isInValidArc(degs);
        }
        return inside;
    }

    @Override
    public void setMouseORA(boolean strict) {
        if (strict || !strict && !this.rotArcOnly) {
            this.overRotArcOnly = strict;
        }
    }

    public boolean isRotArcOnly() {
        return this.rotArcOnly;
    }

    public void setRotArcOnly(boolean rotArcOnly) {
        this.rotArcOnly = rotArcOnly;
        if (rotArcOnly) {
            this.overRotArcOnly = true;
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        p.x += this.cx;
        p.y += this.cy;
        float rad = PApplet.radians((float)this.needleAngle);
        this.winApp.pushMatrix();
        this.winApp.translate((float)p.x, (float)p.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        if (this.bezelWidth > 0) {
            this.winApp.noStroke();
            if (this.rotArcOnly) {
                this.winApp.fill(this.winApp.color(128, 128));
            } else {
                this.winApp.fill(this.winApp.color(128, 48));
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.sizeRadX), (float)(2 * this.sizeRadY));
                this.winApp.fill(this.winApp.color(128, 80));
            }
            this.winApp.arc(0.0f, 0.0f, (float)(2 * this.sizeRadX), (float)(2 * this.sizeRadY), this.start, this.end);
            if (this.valueTrackVisible) {
                this.winApp.fill(this.localColor.knobTrack);
                this.winApp.noStroke();
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.barRadX), (float)(2 * this.barRadY), this.start, rad);
            }
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            int i = 0;
            while (i < this.mark.length) {
                if (i == 0 || i == this.mark.length - 1) {
                    this.winApp.strokeWeight(1.5f);
                } else {
                    this.winApp.strokeWeight(1.2f);
                }
                this.winApp.line((float)this.mark[i][0].x, (float)this.mark[i][0].y, (float)this.mark[i][1].x, (float)this.mark[i][1].y);
                ++i;
            }
        }
        if (this.knobRadX > 0) {
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            this.winApp.fill(this.localColor.knobFill);
            if (this.rotArcOnly) {
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY), this.start, this.end);
                this.winApp.stroke(this.localColor.knobBorder);
                this.winApp.strokeWeight(1.2f);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[0][0].x, (float)this.mark[0][0].y);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[this.mark.length - 1][0].x, (float)this.mark[this.mark.length - 1][0].y);
            } else {
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY));
            }
            this.winApp.stroke(this.localColor.knobNeedle);
            this.winApp.strokeWeight(1.5f);
            this.winApp.line(0.0f, 0.0f, (float)Math.round((double)(this.sizeRadX - this.bezelWidth) * Math.cos(rad)), (float)Math.round((double)(this.sizeRadY - this.bezelWidth) * Math.sin(rad)));
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
    }
}

