/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GConstants;
import guicomponents.GFont;
import guicomponents.GMessenger;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public abstract class GComponent
implements PConstants,
GConstants,
Comparable<Object> {
    protected static GComponent focusIsWith = null;
    protected static GComponent keyFocusIsWith = null;
    protected static GComponent cursorIsOver;
    protected int mdx = Integer.MAX_VALUE;
    protected int mdy = Integer.MAX_VALUE;
    public static GCScheme globalColor;
    public GCScheme localColor;
    public static PFont globalFont;
    public PFont localFont;
    protected static int componentNo;
    protected static final int PADH = 4;
    protected static final int PADV = 2;
    protected static final int Z_PANEL = 32;
    protected static final int Z_STICKY = 16;
    protected static final int Z_SLIPPY = 24;
    protected PApplet winApp;
    protected GComponent parent = null;
    protected HashSet<GComponent> children;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected String text = "";
    protected int textWidth;
    protected int textAlignHorz = 1;
    protected int textAlignVert = 64;
    protected int alignX = 0;
    protected int alignY = 0;
    protected int x;
    protected int y;
    public int z = 0;
    protected int width;
    protected int height;
    public String tag;
    public int tagNo;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected int border = 0;
    protected boolean opaque = true;
    public int eventType = 0;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;

    static {
        componentNo = 0;
    }

    private GComponent() {
    }

    public GComponent(PApplet theApplet, int x, int y) {
        this.winApp = theApplet;
        this.tag = "#" + PApplet.nf((int)componentNo++, (int)5) + " " + this.getClass().getSimpleName();
        this.z = 0;
        if (globalColor == null) {
            globalColor = GCScheme.getColor(theApplet);
        }
        this.localColor = new GCScheme(globalColor);
        if (globalFont == null) {
            globalFont = GFont.getDefaultFont(theApplet);
        }
        this.localFont = globalFont;
        this.x = x;
        this.y = y;
        G4P.setMainApp(this.winApp);
        G4P.addComponent(this);
    }

    protected void createEventHandler(Object handlerObj, String methodName, Class[] parameters) {
        try {
            this.eventHandlerMethod = handlerObj.getClass().getMethod(methodName, parameters);
            this.eventHandlerObject = handlerObj;
            this.eventHandlerMethodName = methodName;
        }
        catch (Exception e) {
            GMessenger.message(0x1000001, this, new Object[]{methodName, parameters});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object obj, String methodName) {
        try {
            this.eventHandlerObject = obj;
            this.eventHandlerMethodName = methodName;
            this.eventHandlerMethod = obj.getClass().getMethod(methodName, this.getClass());
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    public void addEventHandler(Object obj, String methodName, Class[] parameters) {
        if (parameters == null) {
            parameters = new Class[]{};
        }
        try {
            this.eventHandlerObject = obj;
            this.eventHandlerMethodName = methodName;
            this.eventHandlerMethod = obj.getClass().getMethod(methodName, parameters);
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this.eventHandlerObject, new Object[]{methodName, parameters});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
            }
            catch (Exception e) {
                GMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, e});
            }
        }
    }

    public PApplet getPApplet() {
        return this.winApp;
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.loseFocus(this);
        }
        focusIsWith = this;
        keyFocusIsWith = null;
    }

    protected void loseFocus(GComponent grabber) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = null;
    }

    public void setFocus(boolean focus) {
        if (focus) {
            this.takeFocus();
        } else {
            this.loseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    public boolean hasKeyFocus() {
        return this == keyFocusIsWith;
    }

    public static GComponent getFocusObject() {
        return focusIsWith;
    }

    public static int focusObjectZ() {
        return focusIsWith == null ? -1 : GComponent.focusIsWith.z;
    }

    public int getEventType() {
        return this.eventType;
    }

    protected boolean mouseHasMoved(int x, int y) {
        return this.mdx != x || this.mdy != y;
    }

    public boolean add(GComponent component) {
        if (component == null || this.children.contains(component)) {
            if (G4P.messages) {
                System.out.println("Either the component doesn't exist or has already been added to this component");
            }
            return false;
        }
        component.parent = this;
        this.children.add(component);
        component.setZ(this.z);
        this.winApp.unregisterDraw((Object)component);
        component.regDraw = false;
        if (this.localColor.getAlpha() < 255) {
            component.setAlpha(this.localColor.getAlpha());
        }
        return true;
    }

    protected void setZ(int parentZ) {
        this.z += parentZ;
        if (this.children != null) {
            for (GComponent c : this.children) {
                c.setZ(this.z);
            }
        }
    }

    public void remove(GComponent component) {
        this.children.remove(component);
        component.unsetZ(this.z);
    }

    protected void unsetZ(int parentZ) {
        this.z -= parentZ;
        if (this.children != null) {
            for (GComponent c : this.children) {
                c.unsetZ(parentZ);
            }
        }
    }

    public void pre() {
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    protected void registerAutos_DMPK(boolean draw, boolean mouse, boolean pre, boolean key) {
        if (draw && G4P.isAutoDrawOn()) {
            this.winApp.registerDraw((Object)this);
            this.regDraw = true;
        }
        if (mouse) {
            this.winApp.registerMouseEvent((Object)this);
            this.regMouse = true;
        }
        if (pre) {
            this.winApp.registerPre((Object)this);
            this.regPre = true;
        }
        if (key) {
            this.winApp.registerKeyEvent((Object)this);
            this.regKey = true;
        }
    }

    public void dispose() {
        if (this.regDraw) {
            this.winApp.unregisterDraw((Object)this);
        }
        if (this.regMouse) {
            this.winApp.unregisterMouseEvent((Object)this);
        }
        if (this.regPre) {
            this.winApp.unregisterPre((Object)this);
        }
        if (this.regKey) {
            this.winApp.unregisterKeyEvent((Object)this);
        }
        G4P.dumpComponent(this);
    }

    public void changeWindow(PApplet newWindowApp) {
        if (this.regDraw) {
            this.winApp.unregisterDraw((Object)this);
            newWindowApp.registerDraw((Object)this);
        }
        if (this.regPre) {
            this.winApp.unregisterPre((Object)this);
            newWindowApp.registerPre((Object)this);
        }
        if (this.regMouse) {
            this.winApp.unregisterMouseEvent((Object)this);
            newWindowApp.registerMouseEvent((Object)this);
        }
        if (this.regKey) {
            this.winApp.unregisterKeyEvent((Object)this);
            newWindowApp.registerKeyEvent((Object)this);
        }
        this.winApp = newWindowApp;
        if (this.children != null && !this.children.isEmpty()) {
            Iterator<GComponent> iter = this.children.iterator();
            while (iter.hasNext()) {
                iter.next().changeWindow(newWindowApp);
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        return ax >= p.x && ax <= p.x + this.width && ay >= p.y && ay <= p.y + this.height;
    }

    public void calcAbsPosition(Point d) {
        if (this.parent != null) {
            this.parent.calcAbsPosition(d);
        }
        d.x += this.x;
        d.y += this.y;
    }

    public GComponent getParent() {
        return this.parent;
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.winApp.textFont(this.localFont, (float)this.localFont.getFont().getSize());
        this.textWidth = (int)this.winApp.textWidth(text);
        this.calcAlignX();
        this.calcAlignY();
    }

    public void setText(String text, int align) {
        this.text = text;
        this.winApp.textFont(this.localFont, (float)this.localFont.getFont().getSize());
        this.textWidth = (int)this.winApp.textWidth(text);
        this.setTextAlign(align);
    }

    public void setTextAlign(int align) {
        int ha = align & 7;
        int va = align & 0x70;
        if (ha == 1 || ha == 4 || ha == 2) {
            this.textAlignHorz = ha;
            this.calcAlignX();
        }
        if (va == 16 || va == 64 || va == 32) {
            this.textAlignVert = va;
            this.calcAlignY();
        }
    }

    public void setFont(String fontname, int fontsize) {
    }

    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.width - this.textWidth - this.border - 4;
                break;
            }
            case 4: {
                this.alignX = (this.width - this.textWidth) / 2;
            }
        }
    }

    protected void calcAlignY() {
        switch (this.textAlignVert) {
            case 16: {
                this.alignY = this.border + 2;
                break;
            }
            case 32: {
                this.alignY = this.height - this.localFont.getFont().getSize() - this.border - 2;
                break;
            }
            case 64: {
                this.alignY = (this.height - this.localFont.getFont().getSize() - this.border - 2) / 2;
            }
        }
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (this.children != null) {
            for (GComponent c : this.children) {
                c.setEnabled(enable);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean visible) {
        if (!visible && focusIsWith == this) {
            this.loseFocus(null);
        }
        this.visible = visible;
    }

    public void setBorder(int border) {
        this.border = border;
        this.calcAlignX();
    }

    public int getBorder() {
        return this.border;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public boolean getOpaque() {
        return this.opaque;
    }

    public void setAlpha(int alpha) {
        this.localColor.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.localColor.getAlpha();
    }

    public String toString() {
        return String.valueOf(this.tag) + "   (" + this.z + ")";
    }

    @Override
    public int compareTo(Object o) {
        return new Integer(this.hashCode()).compareTo(new Integer(o.hashCode()));
    }
}

