/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class GClip
implements ClipboardOwner {
    private static GClip gclip = null;
    private Clipboard clipboard = null;

    public static boolean copy(String chars) {
        if (gclip == null) {
            gclip = new GClip();
        }
        return gclip.copyString(chars);
    }

    public static String paste() {
        if (gclip == null) {
            gclip = new GClip();
        }
        return gclip.pasteString();
    }

    private GClip() {
        if (this.clipboard == null) {
            this.makeClipboardObject();
        }
    }

    private void makeClipboardObject() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkSystemClipboardAccess();
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException e) {
                this.clipboard = new Clipboard("Application Clipboard");
            }
        } else {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean copyString(String chars) {
        if (this.clipboard == null) {
            this.makeClipboardObject();
        }
        if (this.clipboard != null) {
            StringSelection fieldContent = new StringSelection(chars);
            this.clipboard.setContents(fieldContent, this);
            return true;
        }
        return false;
    }

    private String pasteString() {
        if (this.clipboard == null) {
            this.makeClipboardObject();
            return "";
        }
        Transferable clipboardContent = this.clipboard.getContents(this);
        if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String tempString = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                return tempString;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

