/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GCheckbox
extends GComponent {
    protected boolean selected;
    protected static PImage imgSelected;
    protected static PImage imgCleared;

    public GCheckbox(PApplet theApplet, String text, int x, int y, int width) {
        super(theApplet, x, y);
        this.checkboxCtorCore(text, width);
    }

    private void checkboxCtorCore(String text, int width) {
        if (imgSelected == null) {
            imgSelected = this.winApp.loadImage("check1.png");
        }
        if (imgCleared == null) {
            imgCleared = this.winApp.loadImage("check0.png");
        }
        this.width = width;
        this.height = Math.max(this.localFont.getFont().getSize() + 4, GCheckbox.imgCleared.height);
        this.opaque = false;
        this.setText(text);
        this.z = 24;
        this.createEventHandler(this.winApp, "handleCheckboxEvents", new Class[]{GCheckbox.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    @Override
    public void setFont(String fontname, int fontsize) {
        int tw = this.textWidth;
        int fs = this.localFont.getFont().getSize();
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (fontsize != fs) {
            this.height += fontsize - fs;
        }
        this.setText(this.text);
        if (this.textWidth > tw) {
            this.width += this.textWidth - tw;
        }
    }

    @Override
    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = GCheckbox.imgSelected.width + 2 * this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.width - this.textWidth - 2 * this.border - 4;
                break;
            }
            case 4: {
                this.alignX = GCheckbox.imgSelected.width + (this.width - GCheckbox.imgSelected.width - this.textWidth) / 2;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (!this.text.equals("")) {
            if (this.border != 0) {
                this.winApp.strokeWeight((float)this.border);
                this.winApp.stroke(this.localColor.cbxBorder);
            } else {
                this.winApp.noStroke();
            }
            if (this.opaque) {
                this.winApp.fill(this.localColor.cbxBack);
            } else {
                this.winApp.noFill();
            }
            this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
            this.winApp.noStroke();
            this.winApp.fill(this.localColor.cbxFont);
            this.winApp.textFont(this.localFont, (float)this.localFont.getFont().getSize());
            this.winApp.text(this.text, (float)(pos.x + this.alignX), (float)(pos.y + (this.height - this.localFont.getFont().getSize()) / 2 - 2), (float)this.textWidth, (float)this.height);
        }
        this.winApp.fill(this.winApp.color(255, 255));
        if (this.selected) {
            this.winApp.image(imgSelected, (float)pos.x, (float)(pos.y + (this.height - GCheckbox.imgSelected.height) / 2));
        } else {
            this.winApp.image(imgCleared, (float)pos.x, (float)(pos.y + (this.height - GCheckbox.imgSelected.height) / 2));
        }
        this.winApp.popStyle();
    }

    @Override
    public void mouseEvent(MouseEvent event) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver || this.z <= GCheckbox.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.selected = !this.selected;
                this.eventType = this.selected ? 1025 : 1026;
                this.fireEvent();
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

