/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class RandomRender {
    public static void main(String[] stringArray) throws Exception {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Configuration configuration = new Configuration();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        String string = null;
        String string2 = null;
        Object var31_19 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-d".equals(stringArray[i])) {
                string3 = stringArray[++i];
                continue;
            }
            if ("-o".equals(stringArray[i])) {
                string4 = stringArray[++i];
                continue;
            }
            if (!"-a".equals(stringArray[i])) continue;
            string2 = stringArray[++i];
        }
        if (string2 == null) {
            System.out.println("You need to give a parameter file and a round name for the exploration");
            System.exit(1);
        }
        JSONObject jSONObject = null;
        try {
            object5 = new FileInputStream(string2);
            object4 = new DataInputStream((InputStream)object5);
            object3 = new BufferedReader(new InputStreamReader((InputStream)object4));
            object2 = "";
            while ((object = ((BufferedReader)object3).readLine()) != null) {
                object2 = (String)object2 + (String)object;
            }
            jSONObject = new JSONObject((String)object2);
            ((FilterInputStream)object4).close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        object5 = "";
        object4 = "";
        object3 = new Random();
        object2 = new JSONArray();
        try {
            string = jSONObject.getString("op_type");
            n3 = jSONObject.getInt("ndim");
            d6 = jSONObject.getDouble("shiftx");
            d7 = jSONObject.getDouble("shifty");
            d8 = jSONObject.getDouble("resolution");
            n2 = jSONObject.getInt("nsteps");
            d10 = jSONObject.getDouble("step_length");
            d9 = jSONObject.getDouble("scale");
            object2 = jSONObject.getJSONArray("nalpha");
        }
        catch (Exception exception) {
            System.out.println("necessary parameters are not set");
            System.exit(1);
        }
        double[] dArray = new double[n3];
        try {
            object = jSONObject.getJSONArray("theta");
            for (n = 0; n < n3; ++n) {
                dArray[n] = ((JSONArray)object).getDouble(n);
            }
        }
        catch (Exception exception) {
            for (n = 0; n < n3; ++n) {
                dArray[n] = Math.PI / (double)n3 * 2.0 * (double)n;
            }
        }
        double d13 = 0.0;
        if (string.equals("SS")) {
            try {
                d5 = jSONObject.getDouble("sample_rate");
                n4 = jSONObject.getInt("max_samples");
                d = jSONObject.getDouble("xstart");
                d2 = jSONObject.getDouble("xend");
                d3 = jSONObject.getDouble("ystart");
                d4 = jSONObject.getDouble("yend");
                d13 = jSONObject.getDouble("rescale");
            }
            catch (Exception exception) {
                System.out.println("necessary parameters of the selected frame are missing for subset selection");
                System.exit(1);
            }
            double d14 = (d2 + d) / 2.0;
            double d15 = (d4 + d3) / 2.0;
            double d16 = d6 + d14;
            double d17 = d7 + d15;
            configuration.set("shiftx2", String.valueOf(d16));
            configuration.set("shifty2", String.valueOf(d17));
            configuration.set("rescale", String.valueOf(d13));
            configuration.set("sample_rate", String.valueOf(d5));
            configuration.set("max_samples", String.valueOf(n4));
            configuration.set("xstart", String.valueOf(d));
            configuration.set("xend", String.valueOf(d2));
            configuration.set("ystart", String.valueOf(d3));
            configuration.set("yend", String.valueOf(d4));
        }
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n2; ++i) {
            int n5;
            String string5 = "";
            String string6 = "";
            JSONArray jSONArray = ((JSONArray)object2).getJSONArray(i);
            for (n5 = 0; n5 < n3; ++n5) {
                dArray2[n5] = jSONArray.getDouble(n5);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                double d18 = dArray2[n5] * Math.cos(dArray[n5]) * d9 * 40.0 / (double)n3;
                double d19 = -dArray2[n5] * Math.sin(dArray[n5]) * d9 * 40.0 / (double)n3;
                string5 = string5 + String.valueOf(d18) + ",";
                string6 = string6 + String.valueOf(d19) + ",";
            }
            object5 = (String)object5 + string5 + '\n';
            object4 = (String)object4 + string6 + '\n';
        }
        configuration.set("op_type", string);
        configuration.set("nsteps", String.valueOf(n2));
        configuration.set("paramx", (String)object5);
        configuration.set("paramy", (String)object4);
        configuration.set("ndim", String.valueOf(n3));
        configuration.set("shiftx", String.valueOf(d6));
        configuration.set("shifty", String.valueOf(d7));
        configuration.set("resolution", String.valueOf(d8));
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystem.get((Configuration)configuration);
            fileSystem.delete(new Path(string4));
        }
        catch (Exception exception) {
            System.out.println("cannot delete " + string4);
        }
        Job job = new Job(configuration, "cloudvista");
        job.setJarByClass(RandomRender.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(MapClass.class);
        job.setCombinerClass(ReduceClass.class);
        job.setReducerClass(ReduceClass.class);
        job.setPartitionerClass(RRPartitioner.class);
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        job.setNumReduceTasks(n2);
        FileInputFormat.setInputPaths((Job)job, (String)string3);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(string4));
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class ReduceClass
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private LongWritable result = new LongWritable();

        public void reduce(Text text, Iterable<LongWritable> iterable, Reducer.Context context) throws IOException, InterruptedException {
            long l = 0L;
            for (LongWritable longWritable : iterable) {
                l += longWritable.get();
            }
            this.result.set(l);
            context.write((Object)text, (Object)this.result);
        }
    }

    public static class RRPartitioner
    extends Partitioner<Text, LongWritable> {
        public void configure(Configuration configuration) {
        }

        public int getPartition(Text text, LongWritable longWritable, int n) {
            int n2;
            char[] cArray = text.toString().toCharArray();
            for (n2 = 0; n2 < cArray.length && cArray[n2] != '|'; ++n2) {
            }
            String string = new String(cArray, 0, n2);
            return Integer.parseInt(string) % n;
        }
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, LongWritable> {
        private int nsteps;
        private int ndim;
        private int max_samples;
        private double shiftx;
        private double shifty;
        private double resol;
        private double xstart;
        private double xend;
        private double ystart;
        private double yend;
        private double sample_rate;
        private double rescale;
        private double shiftx2;
        private double shifty2;
        private double[][] paramx;
        private double[][] paramy;
        private LongWritable one;
        private String op;

        public void setup(Mapper.Context context) {
            Configuration configuration = context.getConfiguration();
            this.op = configuration.get("op_type");
            this.nsteps = Integer.parseInt(configuration.get("nsteps"));
            this.ndim = Integer.parseInt(configuration.get("ndim"));
            this.shiftx = Double.parseDouble(configuration.get("shiftx"));
            this.shifty = Double.parseDouble(configuration.get("shifty"));
            this.resol = Double.parseDouble(configuration.get("resolution"));
            this.one = new LongWritable(1L);
            this.paramx = new double[this.nsteps][];
            this.paramy = new double[this.nsteps][];
            String string = configuration.get("paramx");
            String[] stringArray = string.split("\n");
            string = configuration.get("paramy");
            String[] stringArray2 = string.split("\n");
            for (int i = 0; i < this.nsteps; ++i) {
                int n;
                double[] dArray = new double[this.ndim];
                String[] stringArray3 = stringArray[i].split(",");
                for (n = 0; n < this.ndim; ++n) {
                    dArray[n] = Double.parseDouble(stringArray3[n]);
                }
                this.paramx[i] = dArray;
                dArray = new double[this.ndim];
                stringArray3 = stringArray2[i].split(",");
                for (n = 0; n < this.ndim; ++n) {
                    dArray[n] = Double.parseDouble(stringArray3[n]);
                }
                this.paramy[i] = dArray;
            }
            if (this.op.equals("SS")) {
                this.xstart = Double.parseDouble(configuration.get("xstart")) - this.shiftx;
                this.ystart = Double.parseDouble(configuration.get("ystart")) - this.shifty;
                this.yend = Double.parseDouble(configuration.get("yend")) - this.shifty;
                this.xend = Double.parseDouble(configuration.get("xend")) - this.shiftx;
                this.sample_rate = Double.parseDouble(configuration.get("sample_rate"));
                this.max_samples = Integer.parseInt(configuration.get("max_samples"));
                this.rescale = Double.parseDouble(configuration.get("rescale"));
                this.shiftx2 = Double.parseDouble(configuration.get("shiftx2"));
                this.shifty2 = Double.parseDouble(configuration.get("shifty2"));
            }
        }

        public void map(LongWritable longWritable, Text text, Mapper.Context context) throws IOException, InterruptedException {
            int n;
            String string = text.toString();
            String[] stringArray = string.split(" ");
            double[] dArray = new double[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                dArray[n] = Double.parseDouble(stringArray[n]);
            }
            for (n = 0; n < this.nsteps; ++n) {
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < this.ndim; ++i) {
                    d += dArray[i] * this.paramx[n][i];
                    d2 += dArray[i] * this.paramy[n][i];
                }
                d = (d - this.shiftx) / this.resol;
                d2 = (d2 - this.shifty) / this.resol;
                if (this.op.equals("RR")) {
                    context.write((Object)new Text(String.valueOf(n) + "|" + String.valueOf(Math.round((float)d)) + "|" + String.valueOf(Math.round((float)d2))), (Object)this.one);
                    continue;
                }
                double d3 = 0.0;
                double d4 = 0.0;
                if (n == 0) {
                    d3 = d;
                    d4 = d2;
                } else {
                    for (int i = 0; i < this.ndim; ++i) {
                        d3 += dArray[i] * this.paramx[0][i];
                        d4 += dArray[i] * this.paramy[0][i];
                    }
                    d3 = (d3 - this.shiftx) / this.resol;
                    d4 = (d4 - this.shifty) / this.resol;
                }
                if (!(d3 <= this.xend) || !(d3 >= this.xstart) || !(d4 <= this.yend) || !(d4 >= this.ystart)) continue;
                d = d3 * this.resol + this.shiftx;
                d2 = d4 * this.resol + this.shifty;
                d = (d - this.shiftx2) * this.rescale / this.resol;
                d2 = (d2 - this.shifty2) * this.rescale / this.resol;
                context.write((Object)new Text(String.valueOf(n) + "|" + String.valueOf(Math.round((float)d)) + "|" + String.valueOf(Math.round((float)d2))), (Object)this.one);
            }
        }
    }
}

