/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.ui;

import com.cloud.vista.CloudVista;
import com.cloud.vista.VisualFrame;
import com.cloud.vista.common.Logging;
import com.cloud.vista.common.Tools;
import com.cloud.vista.mapred.CloudManager;
import com.cloud.vista.ui.ExploreManager;
import com.cloud.vista.widgets.Point;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import processing.core.PApplet;

public class VisualExplorer
extends PApplet
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static VisualFrame currentVisualFrame = null;
    public static int tickValue = 0;
    public static float scaleFactor = 1.0f;
    public static int currentViewID = 0;
    public static boolean play = true;
    public static final float TICK_MAX = 10.0f;
    public static final float TICK_MIN = -10.0f;
    public static final float ZOOM_STEP = 1.0f;
    public static int REDRAW_INTERVAL = 1000;
    public static final int MINIMUM_REGION_SIZE = 10;
    public static float translateX = 250.0f;
    public static float translateY = 260.0f;
    private static int resolution = 1;
    public static int screenWidth = 600;
    public static int screenHeight = 680;
    public static String resourceDir = "resources/";
    public static CloudManager cloudManager = new CloudManager();
    private static float translateLength = 30.0f;
    private static float selStartX;
    private static float selStartY;
    private static float selEndX;
    private static float selEndY;

    public VisualExplorer() {
    }

    public VisualExplorer(int screenw, int screenh) {
        screenWidth = screenw;
        screenHeight = screenh;
        translateX = screenw / 2;
        translateY = screenh / 2;
    }

    public static void setCurrentViewID(int id) {
        currentViewID = id;
    }

    public static void setMapRedProgress(float mapVal, float redVal) {
    }

    public static void setScaleFactor(float scale) {
        scaleFactor = scale;
        tickValue = VisualExplorer.scaleToTick();
    }

    public static void setTickValue(int tick) {
        tickValue = tick;
        scaleFactor = VisualExplorer.tickToScale();
    }

    public static int getResolution() {
        return resolution;
    }

    public static float getTransX() {
        return translateX;
    }

    public static float getTransY() {
        return translateY;
    }

    public static double getScaleFactor() {
        return scaleFactor;
    }

    public static int getTickValue() {
        return tickValue;
    }

    private static float tickToScale() {
        return (float)(3.0 / (1.0 + 2.0 * Math.exp(-tickValue)));
    }

    private static int scaleToTick() {
        return (int)Math.log((3.0f / scaleFactor - 1.0f) / 2.0f);
    }

    public static float[] dataPointToScreenPoint(float datax, float datay) {
        float[] screenp = new float[]{datax * scaleFactor + translateX, datay * scaleFactor + translateY};
        return screenp;
    }

    public static float[] screenPointToDataPoint(float screenx, float screeny) {
        float[] datap = new float[]{(screenx - translateX) / scaleFactor, (screeny - translateY) / scaleFactor};
        return datap;
    }

    public static float[] getSelDataRect() {
        float[] selDataRect = new float[4];
        float[] startp = VisualExplorer.screenPointToDataPoint(selStartX, selStartY);
        selDataRect[0] = startp[0];
        selDataRect[1] = startp[1];
        float[] endp = VisualExplorer.screenPointToDataPoint(selEndX, selEndY);
        selDataRect[2] = endp[0];
        selDataRect[3] = endp[1];
        System.out.println("Subset screen region: (" + VisualExplorer.getSelStartX() + ", " + VisualExplorer.getSelStartY() + ")" + "(" + VisualExplorer.getSelEndX() + ", " + VisualExplorer.getSelEndY() + ")");
        System.out.println("Subset data region: (" + selDataRect[0] + ", " + selDataRect[1] + ")" + "(" + selDataRect[2] + ", " + selDataRect[3] + ")");
        return selDataRect;
    }

    public static float getRescale() {
        return Math.min((float)screenHeight / Math.abs(selEndY - selStartY), (float)screenWidth / Math.abs(selEndX - selStartX));
    }

    public static float[] getSelOrigDataCenter() {
        float[] shift = new float[2];
        float[] selRect = VisualExplorer.getSelDataRect();
        shift[0] = (selRect[2] + selRect[0]) / 2.0f;
        shift[1] = (selRect[3] + selRect[1]) / 2.0f;
        return shift;
    }

    public static float[] getSelScreenCenter() {
        float[] center = new float[]{(selEndX + selStartX) / 2.0f, (selEndY + selStartY) / 2.0f};
        return center;
    }

    public void setup() {
        this.size(screenWidth, screenHeight, "processing.core.PGraphics2D");
        this.smooth();
        this.noStroke();
        this.noLoop();
        this.redraw();
    }

    public void draw() {
        this.background(176.0f, 196.0f, 222.0f);
        if (!play) {
            this.playForward();
        }
        if (ExploreManager.currentExplore != null) {
            currentVisualFrame = ExploreManager.currentExplore.getVisualFrame(currentViewID);
        }
        if (currentVisualFrame == null) {
            System.err.println("Current visual frame is null. ");
            REDRAW_INTERVAL = 5000;
            return;
        }
        REDRAW_INTERVAL = 1000;
        int i = 0;
        while (i < currentVisualFrame.getVisualFramePoints().size()) {
            Point p = currentVisualFrame.getVisualFramePoints().get(i);
            this.fill(p.getPointColor().getRed(), p.getPointColor().getGreen(), p.getPointColor().getBlue());
            float[] point = VisualExplorer.dataPointToScreenPoint(p.getPointX(), p.getPointY());
            this.rect(point[0], point[1], resolution, resolution);
            ++i;
        }
        if (this.mousePressed) {
            this.stroke(0.0f, 100.0f, 205.0f);
            this.strokeWeight(2.0f);
            this.noFill();
            this.rect(selStartX, selStartY, Math.abs((float)this.mouseX - selStartX), Math.abs((float)this.mouseY - selStartY));
            this.noStroke();
            this.redraw();
        }
    }

    public void mousePressed() {
        selStartX = this.mouseX;
        selStartY = this.mouseY;
    }

    public void mouseReleased() {
        selEndX = this.mouseX;
        selEndY = this.mouseY;
        Logging.log("Rectangle: <" + selStartX + "," + selStartY + ">  <" + selEndX + "," + selEndY + ">", 0);
        if (Math.abs(selEndX - selStartX) < 10.0f || Math.abs(selEndY - selStartY) < 10.0f) {
            Logging.log("Selected subset too small, ignored!", 1);
            return;
        }
        if (ExploreManager.currentExplore == null) {
            Logging.log("No related exploration for sub-exploration! ", 2);
            return;
        }
        String expSsName = "";
        do {
            Logging.log("Get sub-set name.", 0);
            expSsName = Tools.promptForExpName("Enter Subset exploration Name:");
            if (!expSsName.equals("") && expSsName != null) continue;
            Logging.log("Sub-set exploration creation stopped. ", 1);
            return;
        } while (expSsName.equals(""));
        if (CloudVista.exploreManager.doNew(ExploreManager.altExplore.getDatasetName(), ExploreManager.altExplore.getExpName(), expSsName)) {
            Logging.log("Created subset exploration " + ExploreManager.altExplore.getFullName() + ", starting visualization now...", 0);
            if (CloudVista.exploreManager.doVisualize()) {
                if (ExploreManager.altExplore.getActualFrameCnt() > 0) {
                    Logging.log("Visualization successful.", 0);
                } else {
                    Logging.log("No visual frames are built, maybe you selected empty area.", 1);
                }
            } else {
                Logging.log("Visualization of subset exploration " + ExploreManager.altExplore.getFullName() + " failed.", 1);
            }
        }
    }

    public void mouseMoved() {
    }

    public void mouseDragged() {
    }

    public static float getSelStartX() {
        return selStartX;
    }

    public static float getSelStartY() {
        return selStartY;
    }

    public static float getSelEndX() {
        return selEndX;
    }

    public static float getSelEndY() {
        return selEndY;
    }

    public static void panUp() {
        translateY -= translateLength;
    }

    public static void panDown() {
        translateY += translateLength;
    }

    public static void panLeft() {
        translateX -= translateLength;
    }

    public static void panRight() {
        translateX += translateLength;
    }

    public static void panCenter() {
        translateX = screenWidth / 2;
        translateY = screenHeight / 2;
    }

    public static void zoomIn() {
        if ((float)tickValue < 10.0f) {
            tickValue = (int)((float)tickValue + 1.0f);
            scaleFactor = VisualExplorer.tickToScale();
        }
    }

    public static void zoomOut() {
        if ((float)tickValue > -10.0f) {
            tickValue = (int)((float)tickValue - 1.0f);
            scaleFactor = VisualExplorer.tickToScale();
        }
    }

    public static void zoomFit() {
        tickValue = 0;
        scaleFactor = 1.0f;
    }

    public void playForward() {
        play = false;
        if (ExploreManager.currentExplore == null) {
            return;
        }
        if (++currentViewID >= ExploreManager.currentExplore.getNumFrames()) {
            currentViewID = 0;
        }
        currentVisualFrame = ExploreManager.currentExplore.getVisualFrame(currentViewID);
        this.redraw();
    }

    public void playBackward() {
        play = false;
        if (ExploreManager.currentExplore == null) {
            return;
        }
        if (--currentViewID < 0) {
            currentViewID = ExploreManager.currentExplore.getNumFrames() - 1;
        }
        currentVisualFrame = ExploreManager.currentExplore.getVisualFrame(currentViewID);
        this.redraw();
    }

    public static void goFirst() {
        currentViewID = 0;
    }

    public static void goLast() {
        if (ExploreManager.currentExplore == null) {
            return;
        }
        currentViewID = ExploreManager.currentExplore.getNumFrames() - 1;
    }

    public static void goFastback() {
        if ((currentViewID -= 2) < 0) {
            currentViewID = 0;
        }
    }

    public static void goFastForward() {
        currentViewID += 2;
        if (ExploreManager.currentExplore == null) {
            return;
        }
        if (currentViewID >= ExploreManager.currentExplore.getNumFrames()) {
            currentViewID = ExploreManager.currentExplore.getNumFrames() - 1;
        }
    }

    public double computeScaleFactor() {
        double selH;
        double scaleHeight;
        double screenW = this.screen.getWidth();
        double screenH = this.screen.getHeight();
        double selW = VisualExplorer.getSelEndX() - VisualExplorer.getSelStartX();
        double scaleWidth = screenW / selW;
        return scaleWidth <= (scaleHeight = screenH / (selH = (double)(VisualExplorer.getSelEndY() - VisualExplorer.getSelStartY()))) ? scaleWidth : scaleHeight;
    }

    public static double[] computeTranslate(double vc1, double vc2, double dc1, double dc2) {
        double[] trans = new double[]{vc1 - dc1, vc2 - dc2};
        return trans;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        this.redraw();
    }
}

