/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.ui;

import com.cloud.vista.CloudVista;
import com.cloud.vista.Exploration;
import com.cloud.vista.common.BuildJson;
import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.cloud.vista.common.SystemSetting;
import com.cloud.vista.common.Tools;
import com.cloud.vista.mapred.CloudManager;
import com.cloud.vista.mapred.MRProgressBar;
import com.cloud.vista.ui.HelpWindow;
import com.cloud.vista.ui.VisualExplorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExploreManager
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static SystemSetting settingWindow = new SystemSetting();
    public static final int MAX_ALLOWED_TREE_DEPTH = 3;
    public static HelpWindow helpWindow = new HelpWindow();
    public static Exploration currentExplore = null;
    public static Exploration altExplore = null;
    private JLabel lblResolution;
    private JLabel lblnumberFrame;
    private JLabel lblDimension;
    private JLabel lblStepLength;
    private JButton btnHelp = null;
    private JTree expTree = null;
    private DefaultMutableTreeNode rootTreeNode = null;
    private JTextField txtResolution;
    private JTextField txtNumberFrame;
    private JTextField txtStepLength;
    private JTextField txtDimension;
    private JTextField txtOperationType;
    private JScrollPane panelStatus;
    public static JTextPane txtPaneLogging;
    private JPanel panelSystem;
    private JButton btnSystemExit;
    private JButton btnSystemSetUp;
    private JPopupMenu popupTreeMenu;
    private JMenuItem pmNew = null;
    private JMenuItem pmVisualize = null;
    private JMenuItem pmEdit = null;
    private JMenuItem pmDelete = null;
    private JMenuItem pmRefresh = null;
    private JButton btnSync = null;
    private JButton btnSave;

    public double getResolution() {
        return Double.parseDouble(this.txtResolution.getText());
    }

    public int getNumFrames() {
        return Integer.parseInt(this.txtNumberFrame.getText());
    }

    public double getStepLength() {
        return Double.parseDouble(this.txtStepLength.getText());
    }

    public int getDimension() {
        return Integer.parseInt(this.txtDimension.getText());
    }

    public String getOperationType() {
        return this.txtOperationType.getText();
    }

    public ExploreManager(int width, int height) {
        this.setBorder(null);
        width = 400;
        height = 800;
        this.setBounds(100, 100, width, height);
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[2];
        nArray[0] = 350;
        gridBagLayout.columnWidths = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = 50;
        nArray2[1] = 329;
        nArray2[2] = 142;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panelSystem = new JPanel();
        this.panelSystem.setBackground(Color.WHITE);
        this.panelSystem.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panelSystem.setLayout(null);
        GridBagConstraints gbc_panelSystem = new GridBagConstraints();
        gbc_panelSystem.insets = new Insets(0, 0, 5, 0);
        gbc_panelSystem.fill = 1;
        gbc_panelSystem.gridx = 0;
        gbc_panelSystem.gridy = 0;
        this.add((Component)this.panelSystem, gbc_panelSystem);
        this.btnSystemExit = new JButton(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "exit.jpg"));
        this.btnSystemExit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                ExploreManager.this.btnSystemExit.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "exit_.jpg"));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                System.exit(0);
                ExploreManager.this.btnSystemExit.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "exit.jpg"));
            }
        });
        this.btnSystemExit.setBounds(10, 7, 31, 31);
        this.panelSystem.add(this.btnSystemExit);
        this.btnSystemSetUp = new JButton(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "settings.jpg"));
        this.btnSystemSetUp.setBounds(96, 7, 31, 31);
        this.btnSystemSetUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                ExploreManager.this.btnSystemSetUp.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "settings_.jpg"));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExploreManager.this.btnSystemSetUp.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "settings.jpg"));
                settingWindow.setVisible(true);
            }
        });
        this.panelSystem.add(this.btnSystemSetUp);
        this.btnHelp = new JButton(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "help.jpg"));
        this.btnHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                ExploreManager.this.btnHelp.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "help_.jpg"));
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                ExploreManager.this.btnHelp.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "help.jpg"));
                helpWindow.setVisible(true);
            }
        });
        this.btnHelp.setBounds(268, 7, 31, 31);
        this.panelSystem.add(this.btnHelp);
        this.btnSync = new JButton(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "sync.jpg"));
        this.btnSync.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                ExploreManager.this.btnSync.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "sync_.jpg"));
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                ExploreManager.this.btnSync.setIcon(new ImageIcon(String.valueOf(Config.LOCAL_ROURCE_DIR) + "sync.jpg"));
                Logging.log("Synchronization with server has not been implemented yet, coming soon...", 1);
            }
        });
        this.btnSync.setBounds(182, 7, 31, 31);
        this.panelSystem.add(this.btnSync);
        this.popupTreeMenu = new JPopupMenu();
        this.popupTreeMenu.setInvoker(this.expTree);
        this.pmVisualize = new JMenuItem("Visualize");
        this.pmVisualize.addActionListener(this);
        this.pmNew = new JMenuItem("New");
        this.pmNew.addActionListener(this);
        this.pmEdit = new JMenuItem("Edit");
        this.pmEdit.addActionListener(this);
        this.pmDelete = new JMenuItem("Delete");
        this.pmDelete.addActionListener(this);
        this.pmRefresh = new JMenuItem("Refresh");
        this.pmRefresh.addActionListener(this);
        this.popupTreeMenu.add(this.pmVisualize);
        this.popupTreeMenu.add(this.pmNew);
        this.popupTreeMenu.add(this.pmEdit);
        this.popupTreeMenu.add(this.pmDelete);
        this.popupTreeMenu.add(this.pmRefresh);
        this.rootTreeNode = new DefaultMutableTreeNode("Datasets");
        this.expTree = new JTree(this.rootTreeNode);
        this.expTree.setFont(new Font("Tahoma", 0, 15));
        this.expTree.setVisibleRowCount(40);
        this.expTree.setEnabled(true);
        this.expTree.setSelectionRow(0);
        this.expTree.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.expTree.getSelectionModel().setSelectionMode(1);
        this.expTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                ExploreManager.this.handleTreeEvent(me);
            }
        });
        JScrollPane scrollPaneTree = new JScrollPane(this.expTree);
        scrollPaneTree.setHorizontalScrollBarPolicy(31);
        scrollPaneTree.setAutoscrolls(true);
        scrollPaneTree.setEnabled(true);
        GridBagConstraints gbc_panelExplorations = new GridBagConstraints();
        gbc_panelExplorations.insets = new Insets(0, 0, 5, 0);
        gbc_panelExplorations.fill = 1;
        gbc_panelExplorations.gridx = 0;
        gbc_panelExplorations.gridy = 1;
        this.add((Component)scrollPaneTree, gbc_panelExplorations);
        JPanel panelParam = new JPanel();
        panelParam.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Exploration Parameters:", 4, 2, null, new Color(0, 0, 255)));
        GridBagConstraints gbc_panelParam = new GridBagConstraints();
        gbc_panelParam.fill = 3;
        gbc_panelParam.insets = new Insets(0, 0, 5, 0);
        gbc_panelParam.gridx = 0;
        gbc_panelParam.gridy = 2;
        this.add((Component)panelParam, gbc_panelParam);
        GridBagLayout gbl_panelParam = new GridBagLayout();
        int[] nArray3 = new int[6];
        nArray3[0] = 142;
        nArray3[1] = 88;
        nArray3[2] = 109;
        nArray3[3] = 78;
        nArray3[4] = 99;
        gbl_panelParam.columnWidths = nArray3;
        int[] nArray4 = new int[6];
        nArray4[0] = 20;
        nArray4[1] = 20;
        nArray4[2] = 19;
        nArray4[3] = 19;
        nArray4[4] = 23;
        gbl_panelParam.rowHeights = nArray4;
        gbl_panelParam.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panelParam.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelParam.setLayout(gbl_panelParam);
        JLabel lblOperationType = new JLabel("Operation Type");
        lblOperationType.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_lblOperationType = new GridBagConstraints();
        gbc_lblOperationType.anchor = 17;
        gbc_lblOperationType.insets = new Insets(0, 0, 5, 5);
        gbc_lblOperationType.gridx = 0;
        gbc_lblOperationType.gridy = 0;
        panelParam.add((Component)lblOperationType, gbc_lblOperationType);
        this.txtOperationType = new JTextField();
        this.txtOperationType.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_txtOperationType = new GridBagConstraints();
        gbc_txtOperationType.fill = 2;
        gbc_txtOperationType.insets = new Insets(0, 0, 5, 5);
        gbc_txtOperationType.gridx = 1;
        gbc_txtOperationType.gridy = 0;
        panelParam.add((Component)this.txtOperationType, gbc_txtOperationType);
        this.txtOperationType.setEditable(false);
        this.txtOperationType.setEnabled(false);
        this.txtOperationType.setToolTipText("Hadoop job input directory on hdfs.");
        this.lblStepLength = new JLabel("Step Length");
        this.lblStepLength.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_lblStepLength = new GridBagConstraints();
        gbc_lblStepLength.anchor = 17;
        gbc_lblStepLength.insets = new Insets(0, 0, 5, 5);
        gbc_lblStepLength.gridx = 0;
        gbc_lblStepLength.gridy = 1;
        panelParam.add((Component)this.lblStepLength, gbc_lblStepLength);
        this.txtStepLength = new JTextField();
        this.txtStepLength.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_txtStepLength = new GridBagConstraints();
        gbc_txtStepLength.fill = 2;
        gbc_txtStepLength.insets = new Insets(0, 0, 5, 5);
        gbc_txtStepLength.gridx = 1;
        gbc_txtStepLength.gridy = 1;
        panelParam.add((Component)this.txtStepLength, gbc_txtStepLength);
        this.txtStepLength.setEnabled(false);
        this.txtStepLength.setToolTipText("Step length of data processing.");
        this.txtStepLength.setColumns(10);
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExploreManager.this.doSave();
            }
        });
        this.btnSave.setToolTipText("Create new exploration with given parameters.");
        this.btnSave.setFont(new Font("Verdana", 1, 15));
        this.btnSave.setEnabled(false);
        GridBagConstraints gbc_button = new GridBagConstraints();
        gbc_button.fill = 3;
        gbc_button.gridheight = 3;
        gbc_button.insets = new Insets(0, 0, 5, 5);
        gbc_button.gridx = 2;
        gbc_button.gridy = 1;
        panelParam.add((Component)this.btnSave, gbc_button);
        this.lblResolution = new JLabel("Resolution");
        this.lblResolution.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_lblResolution = new GridBagConstraints();
        gbc_lblResolution.anchor = 17;
        gbc_lblResolution.insets = new Insets(0, 0, 5, 5);
        gbc_lblResolution.gridx = 0;
        gbc_lblResolution.gridy = 2;
        panelParam.add((Component)this.lblResolution, gbc_lblResolution);
        this.txtResolution = new JTextField();
        this.txtResolution.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_txtResolution = new GridBagConstraints();
        gbc_txtResolution.fill = 2;
        gbc_txtResolution.insets = new Insets(0, 0, 5, 5);
        gbc_txtResolution.gridx = 1;
        gbc_txtResolution.gridy = 2;
        panelParam.add((Component)this.txtResolution, gbc_txtResolution);
        this.txtResolution.setEnabled(false);
        this.txtResolution.setToolTipText("Points density of visual frame window.");
        this.lblDimension = new JLabel("Dimension");
        this.lblDimension.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_lblDimension = new GridBagConstraints();
        gbc_lblDimension.anchor = 17;
        gbc_lblDimension.insets = new Insets(0, 0, 5, 5);
        gbc_lblDimension.gridx = 0;
        gbc_lblDimension.gridy = 3;
        panelParam.add((Component)this.lblDimension, gbc_lblDimension);
        this.txtDimension = new JTextField();
        this.txtDimension.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_txtDimension = new GridBagConstraints();
        gbc_txtDimension.fill = 2;
        gbc_txtDimension.insets = new Insets(0, 0, 5, 5);
        gbc_txtDimension.gridx = 1;
        gbc_txtDimension.gridy = 3;
        panelParam.add((Component)this.txtDimension, gbc_txtDimension);
        this.txtDimension.setEnabled(false);
        this.txtDimension.setToolTipText("Number of dimensions of dataset. ");
        this.txtDimension.setColumns(10);
        this.lblnumberFrame = new JLabel("Number of Frames");
        this.lblnumberFrame.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_lblnumberFrame = new GridBagConstraints();
        gbc_lblnumberFrame.anchor = 17;
        gbc_lblnumberFrame.insets = new Insets(0, 0, 0, 5);
        gbc_lblnumberFrame.gridx = 0;
        gbc_lblnumberFrame.gridy = 4;
        panelParam.add((Component)this.lblnumberFrame, gbc_lblnumberFrame);
        this.txtNumberFrame = new JTextField();
        this.txtNumberFrame.setFont(new Font("Tahoma", 0, 15));
        GridBagConstraints gbc_txtNumberFrame = new GridBagConstraints();
        gbc_txtNumberFrame.fill = 2;
        gbc_txtNumberFrame.insets = new Insets(0, 0, 0, 5);
        gbc_txtNumberFrame.gridx = 1;
        gbc_txtNumberFrame.gridy = 4;
        panelParam.add((Component)this.txtNumberFrame, gbc_txtNumberFrame);
        this.txtNumberFrame.setEnabled(false);
        this.txtNumberFrame.setToolTipText("How many visual frames do you want to generate?");
        txtPaneLogging = new JTextPane();
        txtPaneLogging.setFont(new Font("Tahoma", 0, 12));
        txtPaneLogging.setText("Logging text.");
        this.panelStatus = new JScrollPane(txtPaneLogging);
        this.panelStatus.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                e.getAdjustable().setValue(e.getAdjustable().getMaximum());
            }
        });
        this.panelStatus.setHorizontalScrollBarPolicy(31);
        this.panelStatus.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "System Status", 4, 2, null, Color.BLUE));
        this.panelStatus.setAutoscrolls(true);
        txtPaneLogging.setAutoscrolls(true);
        GridBagConstraints gbc_panelStatus = new GridBagConstraints();
        gbc_panelStatus.insets = new Insets(0, 0, 5, 0);
        gbc_panelStatus.fill = 1;
        gbc_panelStatus.gridx = 0;
        gbc_panelStatus.gridy = 3;
        this.add((Component)this.panelStatus, gbc_panelStatus);
        this.uiInitTree();
        this.uiSetDefaultAllFields();
    }

    public void uiInitTree() {
        ArrayList<String> dss = this.getAllDataSets();
        this.rootTreeNode.removeAllChildren();
        for (String ds : dss) {
            this.createNodes(this.rootTreeNode, ds);
        }
        Enumeration<TreeNode> expChildren = this.rootTreeNode.children();
        while (expChildren.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)expChildren.nextElement();
            String dsName = (String)child.getUserObject();
            ArrayList<String> expNames = this.getDsExplorations(dsName);
            if (expNames == null) continue;
            for (String expName : expNames) {
                this.createNodes(child, expName);
            }
            Enumeration<TreeNode> subChildren = child.children();
            while (subChildren.hasMoreElements()) {
                DefaultMutableTreeNode subChild = (DefaultMutableTreeNode)subChildren.nextElement();
                String expName = (String)subChild.getUserObject();
                ArrayList<String> subExpNames = this.getExpSubExpList(dsName, expName);
                if (subExpNames == null) continue;
                for (String subExpName : subExpNames) {
                    this.createNodes(subChild, subExpName);
                }
            }
        }
        int i = 0;
        while (i < this.expTree.getRowCount()) {
            this.expTree.expandRow(i);
            ++i;
        }
        this.updateUI();
    }

    public void uiUpdateExpFields() {
        if (altExplore == null) {
            Logging.log("Alternate Explore is null. ", 1);
            return;
        }
        this.txtResolution.setText(Double.toString(altExplore.getResolution()));
        this.txtNumberFrame.setText(Integer.toString(altExplore.getNumFrames()));
        this.txtOperationType.setText(altExplore.getExploreType());
        this.txtStepLength.setText(Double.toString(altExplore.getStepLength()));
        this.txtDimension.setText(Integer.toString(altExplore.getDimension()));
        this.updateUI();
    }

    public void uiDisableAllFields() {
        this.txtResolution.setEnabled(false);
        this.txtNumberFrame.setEnabled(false);
        this.txtOperationType.setEnabled(false);
        this.txtStepLength.setEnabled(false);
        this.txtDimension.setEnabled(false);
        this.updateUI();
    }

    public void uiEnableAllFields() {
        this.txtResolution.setEnabled(true);
        this.txtNumberFrame.setEnabled(true);
        this.txtOperationType.setEnabled(true);
        this.txtStepLength.setEnabled(true);
        this.txtDimension.setEnabled(true);
        this.updateUI();
    }

    public void uiSetDefaultAllFields() {
        this.txtResolution.setText("10.0");
        this.txtNumberFrame.setText("10");
        this.txtOperationType.setText("RR");
        this.txtStepLength.setText("0.02");
        this.txtDimension.setText("68");
        this.updateUI();
    }

    public void uiEmptyAllFields() {
        this.txtResolution.setText("");
        this.txtNumberFrame.setText("");
        this.txtOperationType.setText("");
        this.txtStepLength.setText("");
        this.txtDimension.setText("");
        this.updateUI();
    }

    private boolean handleTreeEvent(MouseEvent me) {
        TreePath path = this.expTree.getPathForLocation(me.getX(), me.getY());
        this.popupTreeMenu.setVisible(false);
        if (path == null) {
            return false;
        }
        switch (path.getPathCount()) {
            case 1: {
                this.pmVisualize.setEnabled(false);
                this.pmNew.setEnabled(false);
                this.pmEdit.setEnabled(false);
                this.pmDelete.setEnabled(false);
                this.pmRefresh.setEnabled(true);
                break;
            }
            case 2: {
                this.pmVisualize.setEnabled(false);
                this.pmNew.setEnabled(true);
                this.pmEdit.setEnabled(false);
                this.pmDelete.setEnabled(false);
                this.pmRefresh.setEnabled(true);
                break;
            }
            case 3: {
                this.pmVisualize.setEnabled(true);
                this.pmNew.setEnabled(false);
                this.pmEdit.setEnabled(true);
                this.pmDelete.setEnabled(true);
                this.pmRefresh.setEnabled(true);
                String expName = path.getPathComponent(2).toString();
                String dsName = path.getPathComponent(1).toString();
                String jsonFile = Config.getLocalJsonFileAbsolute(dsName, expName, "");
                if (!new File(jsonFile).exists()) break;
                if (this.loadLocalExplore(jsonFile)) {
                    Logging.log("Show info for explore: " + altExplore.getFullName(), 0);
                    this.uiUpdateExpFields();
                    break;
                }
                Logging.log("Error loading from local file. ", 2);
                this.uiEmptyAllFields();
                break;
            }
            case 4: {
                this.pmVisualize.setEnabled(true);
                this.pmNew.setEnabled(false);
                this.pmEdit.setEnabled(true);
                this.pmDelete.setEnabled(true);
                this.pmRefresh.setEnabled(true);
                String expSsName = path.getPathComponent(3).toString();
                String expName = path.getPathComponent(2).toString();
                String dsName = path.getPathComponent(1).toString();
                String jsonFile = Config.getLocalJsonFileAbsolute(dsName, expName, expSsName);
                if (!new File(jsonFile).exists()) break;
                if (this.loadLocalExplore(jsonFile)) {
                    Logging.log("Show info for explore: " + altExplore.getFullName(), 0);
                    this.uiUpdateExpFields();
                    break;
                }
                Logging.log("Error loading " + altExplore.getFullName() + " from local file. ", 2);
                this.uiEmptyAllFields();
                break;
            }
            default: {
                System.err.println("Wrong path length.");
            }
        }
        if (SwingUtilities.isRightMouseButton(me) && this.expTree.isEnabled()) {
            this.expTree.setSelectionPath(path);
            this.popupTreeMenu.show(null, me.getXOnScreen(), me.getYOnScreen());
            this.repaint();
            this.updateUI();
        }
        return true;
    }

    public ArrayList<String> getAllDataSets() {
        File[] dsets;
        ArrayList<String> dss = new ArrayList<String>();
        File dsDir = new File(Config.LOCAL_EXPLORATIONS_ROOT_DIR);
        if (!dsDir.isDirectory()) {
            System.err.println("Data set: not a dirctory.");
            return null;
        }
        File[] fileArray = dsets = dsDir.listFiles();
        int n = dsets.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                dss.add(f.getName());
            }
            ++n2;
        }
        return dss;
    }

    public ArrayList<String> getDsExplorations(String dset) {
        File[] expss;
        if (dset.equals("")) {
            return null;
        }
        ArrayList<String> exps = new ArrayList<String>();
        File expDir = new File(String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dset);
        if (!expDir.isDirectory()) {
            Logging.log("Exploration: not a directory!", 2);
            return null;
        }
        if (!expDir.exists()) {
            Logging.log("Exploration: directory does not exist!", 2);
            return null;
        }
        File[] fileArray = expss = expDir.listFiles();
        int n = expss.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                exps.add(f.getName());
            }
            ++n2;
        }
        return exps;
    }

    public ArrayList<String> getExpSubExpList(String dsName, String expName) {
        File[] expss;
        if (dsName.equals("") || expName.equals("")) {
            return null;
        }
        ArrayList<String> subexps = new ArrayList<String>();
        File expDir = new File(String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName);
        if (!expDir.isDirectory()) {
            Logging.log("Sub-Exploration: not a directory!", 2);
            return null;
        }
        if (!expDir.exists()) {
            Logging.log("Sub-Exploration: directory does not exist!", 2);
            return null;
        }
        File[] fileArray = expss = expDir.listFiles();
        int n = expss.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                subexps.add(f.getName());
            }
            ++n2;
        }
        return subexps;
    }

    public static boolean removedCorruptedExp(String dsName, String expName) {
        if (dsName.equals("") || expName.equals("")) {
            return false;
        }
        String expDir = String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName;
        String jsonFile = String.valueOf(expDir) + "/" + Config.CONFIG_JSON_FILE_NAME;
        if (!new File(expDir).exists()) {
            return false;
        }
        if (!new File(jsonFile).exists()) {
            File[] files;
            File[] fileArray = files = new File(expDir).listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    if (file.isFile()) {
                        file.delete();
                    } else {
                        File[] subfiles;
                        File[] fileArray2 = subfiles = file.listFiles();
                        int n3 = subfiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File subfile = fileArray2[n4];
                            if (subfile.isDirectory()) {
                                throw new IOException("subset exploration can't contain direcrory, please delete manually.");
                            }
                            subfile.delete();
                            ++n4;
                        }
                        file.delete();
                    }
                }
                catch (Exception ee) {
                    System.out.println("Error deleting corrupted exploration. ");
                    return false;
                }
                ++n2;
            }
            new File(expDir).delete();
        } else {
            File[] dirs;
            File[] fileArray = dirs = new File(expDir).listFiles();
            int n = dirs.length;
            int n5 = 0;
            while (n5 < n) {
                String subExpDir;
                File dir = fileArray[n5];
                if (dir.isDirectory() && !new File(String.valueOf(subExpDir = dir.getAbsolutePath()) + "/" + Config.CONFIG_JSON_FILE_NAME).exists()) {
                    if (new File(String.valueOf(subExpDir) + "/" + Config.FRAME_DATA_FILE_NAME).exists()) {
                        new File(String.valueOf(subExpDir) + "/" + Config.FRAME_DATA_FILE_NAME).delete();
                    }
                    new File(subExpDir).delete();
                }
                ++n5;
            }
        }
        return true;
    }

    public boolean updateExplore() {
        if (altExplore == null) {
            Logging.log("Alternate explore update failed, it is null. ", 1);
            return false;
        }
        if (!this.txtResolution.getText().equals("")) {
            altExplore.setResolution(Double.parseDouble(this.txtResolution.getText()));
        }
        if (!this.txtNumberFrame.getText().equals("")) {
            altExplore.setNumFrames(Integer.parseInt(this.txtNumberFrame.getText()));
        }
        if (!this.txtStepLength.getText().equals("")) {
            altExplore.setStepLength(Double.parseDouble(this.txtStepLength.getText()));
        }
        if (!this.txtDimension.getText().equals("")) {
            altExplore.setDimension(Integer.parseInt(this.txtDimension.getText()));
        }
        altExplore.setNalphas(new double[altExplore.getNumFrames()][altExplore.getDimension()]);
        return true;
    }

    public boolean loadLocalExplore(String fname) {
        File jsonFile = new File(fname);
        if (jsonFile.isDirectory()) {
            System.err.println("Given json file is a directory.");
            return false;
        }
        if (!jsonFile.exists()) {
            System.err.println("Json file does not exist.");
            return false;
        }
        JSONObject ji = null;
        try {
            String l1;
            FileInputStream fstream = new FileInputStream(fname);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String l = "";
            while ((l1 = br.readLine()) != null) {
                l = String.valueOf(l) + l1.trim();
            }
            ji = new JSONObject(l);
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return false;
        }
        JSONArray nalpha = new JSONArray();
        try {
            altExplore = new Exploration(ji.getString("dataset"), ji.getString("name"), ji.getString("ssname"));
            altExplore.setExploreType(ji.getString("op_type"));
            altExplore.setDimension(ji.getInt("ndim"));
            altExplore.setShiftX(ji.getDouble("shiftx"));
            altExplore.setShiftY(ji.getDouble("shifty"));
            altExplore.setResolution(ji.getDouble("resolution"));
            altExplore.setNumFrames(ji.getInt("nsteps"));
            altExplore.setStepLength(ji.getDouble("step_length"));
            altExplore.setScale(ji.getDouble("scale"));
            altExplore.setNalphas(new double[altExplore.getNumFrames()][altExplore.getDimension()]);
            nalpha = ji.getJSONArray("nalpha");
            JSONArray aa = null;
            double[] alpha = new double[altExplore.getDimension()];
            int j = 0;
            while (j < altExplore.getNumFrames()) {
                aa = nalpha.getJSONArray(j);
                int k = 0;
                while (k < altExplore.getDimension()) {
                    alpha[k] = aa.getDouble(k);
                    ++k;
                }
                altExplore.setNalphas(alpha, j);
                ++j;
            }
            if (altExplore.getExploreType().equals("SS")) {
                altExplore.setRescale(ji.getDouble("rescale"));
                altExplore.setXStart(ji.getDouble("xstart"));
                altExplore.setXEnd(ji.getDouble("xend"));
                altExplore.setYStart(ji.getDouble("ystart"));
                altExplore.setYEnd(ji.getDouble("yend"));
            }
        }
        catch (Exception e) {
            System.err.println("necessary parameters are not set -->>");
            altExplore = null;
            return false;
        }
        return true;
    }

    public boolean visualizeExp(Exploration exp) {
        if (exp == null) {
            return false;
        }
        String exploreFileName = exp.getLocalDataFileName();
        if (!new File(exploreFileName).exists()) {
            Tools.showInfo("Building exploration : " + exploreFileName + " on the cloud. ");
            CloudManager.buildExploreAndFetchFile(exp);
        }
        exp.renderVisualFrames(exploreFileName);
        return true;
    }

    public boolean createExp(String dsName, String expName, String expSsName) {
        if (dsName.equals("") || dsName == null) {
            Logging.log("Dataset name can't be empty! ", 2);
            return false;
        }
        if (expName.equals("") || expName == null) {
            Logging.log("Exploration name can't be empty! ", 2);
            return false;
        }
        String jsonFile = "";
        jsonFile = !expSsName.equals("") && expSsName != null ? String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + expSsName + "/" + Config.CONFIG_JSON_FILE_NAME : String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + Config.CONFIG_JSON_FILE_NAME;
        if (new File(jsonFile).exists()) {
            if (this.loadLocalExplore(jsonFile)) {
                Logging.log("Successfully loaded exploration from local json file. ", 0);
            } else {
                Logging.log("Failed loading exploration from local cache, building on the cloud. ", 1);
            }
        } else {
            altExplore = new Exploration(dsName, expName, expSsName);
            if (altExplore.isSubSetExp()) {
                this.configSsExp();
            }
            if (BuildJson.buildJsonFile(jsonFile, altExplore)) {
                Logging.log("Created new exploration " + altExplore.getFullName(), 0);
            }
        }
        return true;
    }

    public boolean saveExp() {
        if (altExplore == null) {
            Logging.log("Save exploration failed, alternate exploration is null. ", 2);
            return false;
        }
        this.updateExplore();
        String dsName = altExplore.getDatasetName();
        String expName = altExplore.getExpName();
        String expSsName = altExplore.getExpSsName();
        return BuildJson.buildJsonFile(Config.getLocalJsonFileAbsolute(dsName, expName, expSsName), altExplore);
    }

    public boolean configSsExp() {
        if (altExplore == null) {
            return false;
        }
        float[] selRect = VisualExplorer.getSelDataRect();
        altExplore.setXStart(selRect[0]);
        altExplore.setYStart(selRect[1]);
        altExplore.setXEnd(selRect[2]);
        altExplore.setYEnd(selRect[3]);
        altExplore.setRescale(VisualExplorer.getRescale());
        altExplore.setShiftX(0.0);
        altExplore.setShiftY(0.0);
        altExplore.setExploreType("SS");
        return true;
    }

    public String promptForDsName() {
        ArrayList<String> dss = this.getAllDataSets();
        JComboBox<Object> cbxDsName = new JComboBox<Object>(dss.toArray());
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Datasets: "));
        panel.add(cbxDsName);
        int result = JOptionPane.showConfirmDialog(null, panel, "Select Data set", 2);
        if (result == 0) {
            return cbxDsName.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        Logging.log("Selected node --->>> " + this.expTree.getSelectionPath().toString(), 0);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.expTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            String string = (String)nodeInfo;
        }
    }

    public boolean createNodes(DefaultMutableTreeNode topNode, String name) {
        if (topNode == null || name.equals("") || topNode.getLevel() >= 3) {
            Logging.log("Error creating new node.....", 2);
            return false;
        }
        switch (topNode.getLevel()) {
            case 0: {
                Logging.log("Created root node.", 0);
                topNode.add(new DefaultMutableTreeNode(name));
                break;
            }
            case 1: {
                Logging.log("Data set Node clicked.", 0);
                topNode.add(new DefaultMutableTreeNode(name));
                break;
            }
            case 2: {
                Logging.log("Exploration Node clicked.", 0);
                topNode.add(new DefaultMutableTreeNode(name));
                break;
            }
            case 3: {
                Logging.log("Sub-Exploration Node clicked. ", 0);
                break;
            }
            default: {
                Logging.log("Error node depth.", 2);
                return false;
            }
        }
        this.expTree.updateUI();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String expSsName = "";
        TreePath path = this.expTree.getSelectionPath();
        this.popupTreeMenu.setVisible(false);
        try {
            expSsName = path.getPathComponent(3).toString();
        }
        catch (Exception ee) {
            expSsName = "";
        }
        switch (ae.getActionCommand()) {
            case "New": {
                String expName;
                String dsName;
                try {
                    dsName = path.getPathComponent(1).toString();
                }
                catch (Exception ee) {
                    dsName = this.promptForDsName();
                }
                try {
                    expName = path.getPathComponent(2).toString();
                }
                catch (Exception ee) {
                    expName = Tools.promptForExpName("Enter Exploration Name: ");
                }
                if (dsName.equals("") || expName.equals("")) {
                    Logging.log("Data set name and exploration name can't be empty!", 2);
                    return;
                }
                this.doNew(dsName, expName, expSsName);
                break;
            }
            case "Edit": {
                this.doEdit();
                break;
            }
            case "Save": {
                this.doSave();
                break;
            }
            case "Delete": {
                if (!this.doDelete()) break;
                DefaultTreeModel model = (DefaultTreeModel)this.expTree.getModel();
                model.removeNodeFromParent((MutableTreeNode)path.getLastPathComponent());
                this.popupTreeMenu.setVisible(false);
                break;
            }
            case "Refresh": {
                this.doRefresh();
                break;
            }
            case "Visualize": {
                this.doVisualize();
                break;
            }
            default: {
                System.err.println("Error command. ");
            }
        }
    }

    public boolean doNew(String dsName, String expName, String expSsName) {
        boolean ret = false;
        if (expSsName.equals("")) {
            this.btnSave.setEnabled(true);
            this.uiEnableAllFields();
        } else {
            this.btnSave.setEnabled(false);
        }
        this.expTree.setEnabled(false);
        this.expTree.setFocusable(false);
        if (this.createExp(dsName, expName, expSsName)) {
            TreePath path = this.expTree.getSelectionPath();
            if (path.getPathCount() == 2) {
                this.createNodes((DefaultMutableTreeNode)path.getLastPathComponent(), altExplore.getExpName());
            }
            if (path.getPathCount() == 3) {
                this.createNodes((DefaultMutableTreeNode)path.getLastPathComponent(), altExplore.getExpSsName());
            }
            if (path.getPathCount() == 4) {
                this.createNodes((DefaultMutableTreeNode)path.getPathComponent(2), altExplore.getExpSsName());
            }
            this.uiUpdateExpFields();
            ret = true;
        } else {
            altExplore = null;
            ret = false;
        }
        if (!expSsName.equals("")) {
            this.btnSave.setEnabled(true);
            this.expTree.setEnabled(true);
            this.expTree.setFocusable(true);
        }
        this.uiInitTree();
        return ret;
    }

    private boolean doEdit() {
        this.btnSave.setEnabled(true);
        this.uiEnableAllFields();
        this.expTree.setEnabled(false);
        this.expTree.setFocusable(false);
        this.uiUpdateExpFields();
        return true;
    }

    private boolean doSave() {
        this.btnSave.setEnabled(false);
        this.uiDisableAllFields();
        this.expTree.setEnabled(true);
        this.expTree.setFocusable(true);
        Logging.log("Saving exploration. ", 0);
        if (this.saveExp()) {
            Logging.log("Sucessfully saved exploration. ", 0);
            return true;
        }
        Logging.log("Save is not sucessful.", 1);
        return false;
    }

    private boolean doDelete() {
        if (altExplore == null) {
            return false;
        }
        if (altExplore.delete()) {
            altExplore = null;
            return true;
        }
        return false;
    }

    public boolean doVisualize() {
        boolean res = true;
        Logging.log("Visualize exploration.", 0);
        new Thread(){

            @Override
            public void run() {
                CloudVista.windowProgress = new MRProgressBar();
                CloudVista.windowProgress.setVisible(true);
                ExploreManager.this.btnSave.setEnabled(false);
                ExploreManager.this.uiDisableAllFields();
                ExploreManager.this.expTree.setEnabled(false);
                ExploreManager.this.expTree.setFocusable(false);
                currentExplore = altExplore;
                if (currentExplore != null) {
                    currentExplore.build();
                    if (currentExplore.getActualFrameCnt() > 0) {
                        VisualExplorer.setCurrentViewID(0);
                        Logging.log("Successfully visualize exploration: ", 0);
                    } else {
                        Logging.log("No visual frames built. ", 1);
                    }
                }
                CloudVista.windowProgress.setVisible(false);
                CloudVista.windowProgress.dispose();
                ExploreManager.this.expTree.setEnabled(true);
                ExploreManager.this.expTree.setFocusable(true);
            }
        }.start();
        return res;
    }

    private void doRefresh() {
        this.uiInitTree();
    }

    public static void main(String[] args) {
        ExploreManager.removedCorruptedExp("test", "test");
    }
}

