/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ScpTo {
    public static boolean copyToRemote(String user, String host, String lfile, String rfile) {
        FileInputStream fis = null;
        try {
            int len;
            JSch jsch = new JSch();
            jsch.addIdentity(Config.PRIVATE_KEY_FILE);
            Session session = jsch.getSession(user, host, 22);
            MyUserInfo ui = new MyUserInfo();
            session.setUserInfo((UserInfo)ui);
            session.connect();
            boolean ptimestamp = true;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (ScpTo.checkAck(in) != 0) {
                Logging.log("Check acknowledgement not zero(2)! ", 2);
            }
            File _lfile = new File(lfile);
            if (ptimestamp) {
                command = "T " + _lfile.lastModified() / 1000L + " 0";
                command = String.valueOf(command) + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(command.getBytes());
                out.flush();
                if (ScpTo.checkAck(in) != 0) {
                    Logging.log("Check acknowledgement not zero(3)! ", 2);
                }
            }
            long filesize = _lfile.length();
            command = "C0644 " + filesize + " ";
            command = lfile.lastIndexOf(47) > 0 ? String.valueOf(command) + lfile.substring(lfile.lastIndexOf(47) + 1) : String.valueOf(command) + lfile;
            command = String.valueOf(command) + "\n";
            out.write(command.getBytes());
            out.flush();
            if (ScpTo.checkAck(in) != 0) {
                Logging.log("Error happened!!", 2);
            }
            fis = new FileInputStream(lfile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (ScpTo.checkAck(in) != 0) {
                Logging.log("Error checking ....", 2);
            }
            out.close();
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            Logging.log(e.getMessage(), 2);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ee) {
                Logging.log(ee.getMessage(), 2);
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String rfile = "/home/ada/build.xml.delete";
        String lfile = "cloudmanager.jsp";
        ScpTo.copyToRemote(Config.SERVER_USER_NAME, Config.SERVER_HOST_NAME, lfile, rfile);
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            int i = 0;
            while (i < prompt.length) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
                ++i;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, String.valueOf(destination) + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                int i2 = 0;
                while (i2 < prompt.length) {
                    response[i2] = texts[i2].getText();
                    ++i2;
                }
                return response;
            }
            return null;
        }
    }
}

