/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ScpFrom {
    public static boolean copyFromRemote(String user, String host, String rfile, String lfile) {
        FileOutputStream fos = null;
        try {
            int c;
            String prefix = null;
            if (new File(lfile).isDirectory()) {
                prefix = String.valueOf(lfile) + File.separator;
            }
            JSch jsch = new JSch();
            jsch.addIdentity(Config.PRIVATE_KEY_FILE);
            Session session = jsch.getSession(user, host, 22);
            MyUserInfo ui = new MyUserInfo();
            session.setUserInfo((UserInfo)ui);
            session.connect();
            String command = "scp -f " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = ScpFrom.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? lfile : String.valueOf(prefix) + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (ScpFrom.checkAck(in) != 0) {
                    Logging.log("Check acknowledgement not zero(1)! ", 2);
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            session.disconnect();
        }
        catch (Exception e) {
            Logging.log(e.getMessage(), 2);
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public static void main(String[] arg) {
        String user = Config.SERVER_USER_NAME;
        String host = Config.SERVER_HOST_NAME;
        String rfile = "~/build.xml";
        String lfile = "test.xxxxxx";
        ScpFrom.copyFromRemote(user, host, rfile, lfile);
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            int i = 0;
            while (i < prompt.length) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
                ++i;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, String.valueOf(destination) + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                int i2 = 0;
                while (i2 < prompt.length) {
                    response[i2] = texts[i2].getText();
                    ++i2;
                }
                return response;
            }
            return null;
        }
    }
}

