/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class RandomRender {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        block42: {
            block41: {
                conf = new Configuration();
                nsteps = 0;
                ndim = 0;
                max_samples = 0;
                xstart = 0.0;
                xend = 0.0;
                ystart = 0.0;
                yend = 0.0;
                sample_rate = 1.0;
                shiftx = 0.0;
                shifty = 0.0;
                resol = 1.0;
                scale = 1.0;
                step_length = 0.0;
                cy = 0.0;
                cx = 0.0;
                op_type = null;
                af = null;
                round_name = null;
                input = null;
                output_path = null;
                nred = true;
                if (args.length != 8) {
                    System.out.println("Usage: RandomRender -d <input> -o <output_path> -a <param_file> -p <round_name>");
                    return;
                }
                i = 0;
                while (i < args.length) {
                    if ("-d".equals(args[i])) {
                        input = args[++i];
                    } else if ("-o".equals(args[i])) {
                        output_path = args[++i];
                    } else if ("-a".equals(args[i])) {
                        af = args[++i];
                    } else if ("-p".equals(args[i])) {
                        round_name = args[++i];
                    }
                    ++i;
                }
                if (af == null || round_name == null) {
                    System.out.println("You need to give a parameter file and a round name for the exploration");
                    System.exit(1);
                }
                alpha = new double[ndim];
                theta = new double[ndim];
                ji = null;
                try {
                    fstream = new FileInputStream(af);
                    in = new DataInputStream(fstream);
                    br = new BufferedReader(new InputStreamReader(in));
                    l = "";
                    while ((l1 = br.readLine()) != null) {
                        l = String.valueOf(l) + l1;
                    }
                    ji = new JSONObject(l);
                    in.close();
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
                paramx = "";
                paramy = "";
                r = new Random();
                jpx = new JSONArray();
                jpy = new JSONArray();
                try {
                    op_type = ji.getString("op_type");
                    ndim = ji.getInt("ndim");
                    shiftx = ji.getDouble("shiftx");
                    shifty = ji.getDouble("shifty");
                    resol = ji.getDouble("resolution");
                    nsteps = ji.getInt("nsteps");
                    step_length = ji.getDouble("step_length");
                    scale = ji.getDouble("scale");
                }
                catch (Exception e) {
                    System.out.println("necessary parameters are not set -->>");
                    System.exit(1);
                }
                alpha = new double[ndim];
                theta = new double[ndim];
                try {
                    tt = ji.getJSONArray("theta");
                    i = 0;
                    while (i < ndim) {
                        theta[i] = tt.getDouble(i);
                        ++i;
                    }
                    break block41;
                }
                catch (Exception e) {
                    i = 0;
                    ** while (i < ndim)
                }
lbl-1000:
                // 1 sources

                {
                    theta[i] = 3.141592653589793 / (double)ndim * 2.0 * (double)i;
                    ++i;
                    continue;
                }
            }
            if (op_type.equals("RR")) {
                try {
                    aa = ji.getJSONArray("alpha");
                    i = 0;
                    while (i < ndim) {
                        alpha[i] = aa.getDouble(i);
                        ++i;
                    }
                    break block42;
                }
                catch (Exception e) {
                    i = 0;
                    ** while (i < ndim)
                }
lbl-1000:
                // 1 sources

                {
                    alpha[i] = 0.5;
                    ++i;
                    continue;
                }
            }
        }
        if (op_type.equals("SS")) {
            try {
                sample_rate = ji.getDouble("sample_rate");
                max_samples = ji.getInt("max_samples");
                xstart = ji.getDouble("xstart");
                xend = ji.getDouble("xend");
                ystart = ji.getDouble("ystart");
                yend = ji.getDouble("yend");
                aa = ji.getJSONArray("alpha");
                i = 0;
                while (i < ndim) {
                    alpha[i] = aa.getDouble(i);
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("necessary alpha parameters of the selected frame are missing for subset selection");
                System.exit(1);
            }
            rescale = 1.0 + Math.max(xend - xstart, yend - ystart) / 1000.0;
            extra_shiftx = (xend + xstart) / 2.0;
            extra_shifty = (yend + ystart) / 2.0;
            shiftx2 = shiftx + extra_shiftx;
            shifty2 = shifty + extra_shifty;
            ji.put("scale", rescale * scale);
            ji.put("shiftx", shiftx2);
            ji.put("shifty", shifty2);
            conf.set("shiftx2", String.valueOf(shiftx2));
            conf.set("shifty2", String.valueOf(shifty2));
            conf.set("rescale", String.valueOf(rescale));
            conf.set("sample_rate", String.valueOf(sample_rate));
            conf.set("max_samples", String.valueOf(max_samples));
            conf.set("xstart", String.valueOf(xstart));
            conf.set("xend", String.valueOf(xend));
            conf.set("ystart", String.valueOf(ystart));
            conf.set("yend", String.valueOf(yend));
        }
        nalpha = new JSONArray();
        i = 0;
        while (i < nsteps) {
            sx = "";
            sy = "";
            j = 0;
            while (j < ndim) {
                px = alpha[j] * Math.cos(theta[j]) * scale * 80.0 / (double)ndim;
                py = -alpha[j] * Math.sin(theta[j]) * scale * 80.0 / (double)ndim;
                sx = String.valueOf(sx) + String.valueOf(px) + ",";
                sy = String.valueOf(sy) + String.valueOf(py) + ",";
                ++j;
            }
            paramx = String.valueOf(paramx) + sx + '\n';
            paramy = String.valueOf(paramy) + sy + '\n';
            aa = new JSONArray();
            try {
                j = 0;
                while (j < ndim) {
                    aa.put(alpha[j]);
                    alpha[j] = (double)(r.nextInt(3) - 1) * step_length + alpha[j];
                    if (alpha[j] < -1.0) {
                        alpha[j] = -1.0;
                    }
                    if (alpha[j] > 1.0) {
                        alpha[j] = 1.0;
                    }
                    ++j;
                }
                nalpha.put((Object)aa);
            }
            catch (Exception e) {
                System.out.println("cannot write parameters");
                System.exit(1);
            }
            ++i;
        }
        try {
            ji.put("nalpha", (Object)nalpha);
        }
        catch (Exception e) {
            System.out.println("cannot write parameters");
            System.exit(1);
        }
        conf.set("op_type", op_type);
        conf.set("nsteps", String.valueOf(nsteps));
        conf.set("paramx", paramx);
        conf.set("paramy", paramy);
        conf.set("ndim", String.valueOf(ndim));
        conf.set("shiftx", String.valueOf(shiftx));
        conf.set("shifty", String.valueOf(shifty));
        conf.set("resolution", String.valueOf(resol));
        System.out.println("parameters");
        System.out.println(conf.get("nsteps"));
        System.out.println(conf.get("ndim"));
        System.out.println(conf.get("shiftx"));
        System.out.println(conf.get("shifty"));
        System.out.println(conf.get("resolution"));
        fs = null;
        try {
            fs = FileSystem.get((Configuration)conf);
            fs.delete(new Path(output_path));
        }
        catch (Exception e) {
            System.out.println("cannot delete " + output_path);
        }
        jo_param = ji.toString(4);
        try {
            op = new BufferedWriter(new FileWriter(String.valueOf(round_name) + ".json"));
            op.write(jo_param, 0, jo_param.length());
            op.close();
        }
        catch (Exception e) {
            System.out.println("writing parameters failed\n");
        }
        job = new Job(conf, "cloudvista");
        job.setJarByClass(RandomRender.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(MapClass.class);
        job.setCombinerClass(ReduceClass.class);
        job.setReducerClass(ReduceClass.class);
        job.setPartitionerClass(RRPartitioner.class);
        job.setNumReduceTasks(nsteps);
        FileInputFormat.setInputPaths((Job)job, (String)input);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output_path));
        System.exit(job.waitForCompletion(true) != false ? 0 : 1);
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, LongWritable> {
        private int nsteps;
        private int ndim;
        private int max_samples;
        private double shiftx;
        private double shifty;
        private double resol;
        private double xstart;
        private double xend;
        private double ystart;
        private double yend;
        private double sample_rate;
        private double rescale;
        private double shiftx2;
        private double shifty2;
        private double[][] paramx;
        private double[][] paramy;
        private LongWritable one;
        private String op;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.op = conf.get("op_type");
            this.nsteps = Integer.parseInt(conf.get("nsteps"));
            this.ndim = Integer.parseInt(conf.get("ndim"));
            this.shiftx = Double.parseDouble(conf.get("shiftx"));
            this.shifty = Double.parseDouble(conf.get("shifty"));
            this.resol = Double.parseDouble(conf.get("resolution"));
            this.one = new LongWritable(1L);
            this.paramx = new double[this.nsteps][];
            this.paramy = new double[this.nsteps][];
            String s = conf.get("paramx");
            String[] pxs = s.split("\n");
            s = conf.get("paramy");
            String[] pys = s.split("\n");
            int i = 0;
            while (i < this.nsteps) {
                double[] p = new double[this.ndim];
                String[] ps = pxs[i].split(",");
                int j = 0;
                while (j < this.ndim) {
                    p[j] = Double.parseDouble(ps[j]);
                    ++j;
                }
                this.paramx[i] = p;
                p = new double[this.ndim];
                ps = pys[i].split(",");
                j = 0;
                while (j < this.ndim) {
                    p[j] = Double.parseDouble(ps[j]);
                    ++j;
                }
                this.paramy[i] = p;
                ++i;
            }
            if (this.op.equals("SS")) {
                this.xstart = Double.parseDouble(conf.get("xstart")) - this.shiftx;
                this.ystart = Double.parseDouble(conf.get("ystart")) - this.shifty;
                this.yend = Double.parseDouble(conf.get("yend")) - this.shifty;
                this.xend = Double.parseDouble(conf.get("xend")) - this.shiftx;
                this.sample_rate = Double.parseDouble(conf.get("sample_rate"));
                this.max_samples = Integer.parseInt(conf.get("max_samples"));
                this.rescale = Double.parseDouble(conf.get("rescale"));
                this.shiftx2 = Double.parseDouble(conf.get("shiftx2"));
                this.shifty2 = Double.parseDouble(conf.get("shifty2"));
            }
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String v = value.toString();
            String[] s = v.split(" ");
            double[] vs = new double[s.length];
            int i = 0;
            while (i < s.length) {
                vs[i] = Double.parseDouble(s[i]);
                ++i;
            }
            i = 0;
            while (i < this.nsteps) {
                double x = 0.0;
                double y = 0.0;
                int j = 0;
                while (j < this.ndim) {
                    x += vs[j] * this.paramx[i][j];
                    y += vs[j] * this.paramy[i][j];
                    ++j;
                }
                x = (x + this.shiftx) / this.resol;
                y = (y + this.shifty) / this.resol;
                if (this.op.equals("RR")) {
                    context.write((Object)new Text(String.valueOf(String.valueOf(i)) + "|" + String.valueOf(Math.round((float)x)) + "|" + String.valueOf(Math.round((float)y))), (Object)this.one);
                } else if (x <= this.xend && x >= this.xstart && y <= this.yend && y >= this.ystart) {
                    x = x * this.resol - this.shiftx;
                    y = y * this.resol - this.shifty;
                    x = (x * this.rescale + this.shiftx2) / this.resol;
                    y = (y * this.rescale + this.shifty2) / this.resol;
                    context.write((Object)new Text(String.valueOf(String.valueOf(i)) + "|" + String.valueOf(Math.round((float)x)) + "|" + String.valueOf(Math.round((float)y))), (Object)this.one);
                }
                ++i;
            }
        }
    }

    public static class RRPartitioner
    extends Partitioner<Text, LongWritable> {
        public void configure(Configuration job) {
        }

        public int getPartition(Text key, LongWritable value, int numPartitions) {
            char[] v = key.toString().toCharArray();
            int i = 0;
            while (i < v.length && v[i] != '|') {
                ++i;
            }
            String k = new String(v, 0, i);
            return Integer.parseInt(k) % numPartitions;
        }
    }

    public static class ReduceClass
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private LongWritable result = new LongWritable();

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long sum = 0L;
            for (LongWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }
}

