/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import com.cloud.vista.ui.VisualExplorer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;

public class MRProgressCheck {
    private static int checkInterval = 5;
    public static int mapProgress = 0;
    public static int reduceProgress = 0;

    public static void main(String[] args) throws InterruptedException {
        MRProgressCheck.periodicCheck();
    }

    public static void periodicCheck() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new CheckTask(), 0L, (long)(checkInterval * 1000));
    }

    public static void checkStatus() {
        try {
            JobStatus[] jobStatuses;
            Configuration conf = new Configuration();
            conf.set("mapred.job.tracker", "130.108.28.157:54311");
            JobClient client = new JobClient(new JobConf(conf));
            JobStatus[] jobStatusArray = jobStatuses = client.getAllJobs();
            int n = jobStatuses.length;
            int n2 = 0;
            while (n2 < n) {
                JobStatus jobStatus = jobStatusArray[n2];
                int runState = jobStatus.getRunState();
                switch (runState) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        mapProgress = (int)(jobStatus.mapProgress() * 100.0f);
                        reduceProgress = (int)(jobStatus.reduceProgress() * 100.0f);
                        System.out.println("Progress of map job --> : " + Integer.toString(mapProgress));
                        System.out.println("Progress of red job --> : " + Integer.toString(reduceProgress));
                    }
                    case 3: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        System.out.println("No job is running...");
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class CheckTask
    extends TimerTask {
        CheckTask() {
        }

        @Override
        public void run() {
            MRProgressCheck.checkStatus();
            VisualExplorer.setMapRedProgress(mapProgress, reduceProgress);
        }
    }
}

