/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Exec {
    public static boolean execHadoopJob(String input, String output, String jsonFile) {
        String cmd = "hadoop jar " + Config.SERVER_JAR_FILE + " RandomRender -d " + input + " -o " + output + " -a " + jsonFile;
        Logging.log("Hadoop Command: " + cmd, 0);
        return Exec.execCmd(cmd);
    }

    public static boolean execGetMerge(String hdfsFile, String exploreFile) {
        String cmd = "hadoop dfs -getmerge " + hdfsFile + " " + exploreFile;
        return Exec.execCmd(cmd);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean execCmd(String command) {
        try {
            JSch jsch = new JSch();
            jsch.addIdentity(Config.PRIVATE_KEY_FILE);
            Session session = jsch.getSession(Config.SERVER_USER_NAME, Config.SERVER_HOST_NAME, Config.SERVER_HOST_PORT);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("compression.s2c", "zlib,none");
            config.put("compression.c2s", "zlib,none");
            session.setConfig(config);
            MyUserInfo ui = new MyUserInfo();
            session.setUserInfo((UserInfo)ui);
            session.connect();
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            channel.setOutputStream((OutputStream)System.out);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                if (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i >= 0) {
                        System.out.print(new String(tmp, 0, i));
                        continue;
                    }
                }
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {
                    Logging.log("Thread error. ", 2);
                    return false;
                }
            }
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            Logging.log(e.getMessage(), 2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String command = "df -h";
        Exec.execCmd(command);
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String userName;
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public boolean promptUserName(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.userName = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            int i = 0;
            while (i < prompt.length) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
                ++i;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, String.valueOf(destination) + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                int i2 = 0;
                while (i2 < prompt.length) {
                    response[i2] = texts[i2].getText();
                    ++i2;
                }
                return response;
            }
            return null;
        }
    }
}

