/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.mapred;

import com.cloud.vista.Exploration;
import com.cloud.vista.common.BuildJson;
import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.cloud.vista.mapred.Exec;
import com.cloud.vista.mapred.MRProgressCheck;
import com.cloud.vista.mapred.ScpFrom;
import com.cloud.vista.mapred.ScpTo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;

public class CloudManager {
    public static String m_serverBase = "http://nimbus.cs.wright.edu:1234/cloudmanager.jsp";
    static String cmdStr = "";

    public void updateProgress() {
        progressChecker backthread = new progressChecker();
        backthread.start();
    }

    @Deprecated
    public String getJobStatus(int req) {
        String reqStr = String.valueOf(m_serverBase) + "?requesttype=" + Integer.toString(req);
        return CloudManager.cloudReader(reqStr);
    }

    @Deprecated
    public String runHadoopJob(String hstr) {
        try {
            String reqStr = String.valueOf(m_serverBase) + "?requesttype=hadoop.runjob&hadoopstr=" + URLEncoder.encode(hstr, "UTF-8");
            return CloudManager.cloudReader(reqStr);
        }
        catch (Exception e) {
            Logging.log("Encoding error. ", 2);
            return "ERROR";
        }
    }

    public static void submitHadoopJob() {
        String jobFileName = "cmd.sh.1";
        String cloudServer = " nimbus.cs.wright.edu";
        cmdStr = String.valueOf(Config.LOCAL_ROURCE_DIR) + "plink.exe -ssh -l ada -pw aaaaa -m " + Config.REMOTE_ROURCE_DIR + "../" + jobFileName + cloudServer;
        String hadoopRunStr1 = "hadoop fs -rmr census_agg1 \n";
        String hadoopRunStr2 = "hadoop jar RR2/RR.jar RandomRender -d /user/kekechen/census.norm -o census_agg1 -a RR2/census_rr.json -p test 2>&1";
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("linux") >= 0) {
                Runtime.getRuntime().exec(hadoopRunStr1);
                cmdStr = "ssh -l ada " + cloudServer + " -C \"" + hadoopRunStr2 + "\"";
            } else {
                FileWriter fwriter = new FileWriter(jobFileName);
                BufferedWriter out = new BufferedWriter(fwriter);
                out.write(". .bash_profile\n");
                out.write(hadoopRunStr1);
                out.write(hadoopRunStr2);
                out.close();
            }
            String cmd = cmdStr;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        Process p = Runtime.getRuntime().exec(cmdStr);
                        InputStream cmdOut = p.getInputStream();
                        InputStreamReader reader = new InputStreamReader(cmdOut);
                        BufferedReader input = new BufferedReader(reader);
                        while ((line = input.readLine()) != null) {
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error while starting hadoop job." + e.getMessage());
                    }
                }
            });
            thread.start();
        }
        catch (Exception e) {
            Logging.log("Error while running hadoop job.", 2);
        }
    }

    @Deprecated
    public void getVisualFrames() {
        Logging.log("Downloading visual frame jobs.......", 0);
        try {
            this.getFiles(10);
        }
        catch (Exception e) {
            System.err.println("Error Downloading files form cloud m_cloudManager.");
        }
    }

    @Deprecated
    private int getFiles(int totalFrames) throws IOException {
        int idx = 1;
        while (idx <= totalFrames) {
            String reqstr = String.valueOf(m_serverBase) + "?requesttype=hadoop.getfile&fidx=" + Integer.toString(idx);
            String savedFileName = "part-0000" + Integer.toString(idx);
            BufferedInputStream in = new BufferedInputStream(new URL(reqstr).openStream());
            FileOutputStream fos = new FileOutputStream(savedFileName);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            System.out.print("Transfering file " + savedFileName + ".");
            while (in.read(data, 0, 1024) >= 0) {
                bout.write(data);
                System.out.print(".");
            }
            Logging.log("Done", 0);
            bout.close();
            in.close();
            ++idx;
        }
        return 0;
    }

    public static String cloudReader(String httpReqUrl) {
        String stat = "UNKNOWN";
        HttpURLConnection con = null;
        URL address = null;
        try {
            try {
                int ch;
                address = new URL(httpReqUrl);
                con = (HttpURLConnection)address.openConnection();
                InputStream instrm = con.getInputStream();
                StringBuffer ss = new StringBuffer();
                while ((ch = instrm.read()) != -1) {
                    ss.append((char)ch);
                }
                instrm.close();
                stat = ss.toString();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        con.disconnect();
        con = null;
        return stat.trim();
    }

    public static boolean buildExploreAndFetchFile(Exploration exp) {
        block5: {
            String hdfsInDir = exp.getHdfsDatasetName();
            String localJsonFile = exp.getLocalJsonFile();
            String remoteJsonFile = exp.getRemoteJsonFile();
            String localExploreFile = exp.getLocalDataFileName();
            String remoteExploreFile = exp.getRemoteDataFileName();
            try {
                Logging.log("Building json file " + localJsonFile + " for " + exp.getFullName(), 0);
                BuildJson.buildJsonFile(localJsonFile, exp);
                Logging.log("Done!", 0);
                Logging.log("Copying json to server " + remoteJsonFile + " please wait ... ", 0);
                Exec.execCmd("mkdir -p " + exp.getRemoteExpRoot());
                ScpTo.copyToRemote(Config.SERVER_USER_NAME, Config.SERVER_HOST_NAME, localJsonFile, remoteJsonFile);
                Logging.log("Done!", 0);
                Logging.log("Deleting target directory first ...", 0);
                Exec.execCmd("hadoop fs -rmr " + exp.getExpName());
                Logging.log("Done!", 0);
                Logging.log("Running hadoop job, please wait ... ", 0);
                Exec.execHadoopJob(hdfsInDir, exp.getExpName(), remoteJsonFile);
                Logging.log("Done!", 0);
                if (Config.COMPRESS_VISUAL_FRAME_DATA) {
                    Logging.log("Use compression for visual data output.", 0);
                    remoteExploreFile = String.valueOf(remoteExploreFile) + ".gz";
                    localExploreFile = String.valueOf(localExploreFile) + ".gz";
                } else {
                    Logging.log("Do Not use compression for visual data output.", 0);
                }
                Logging.log("Merging the visual frame files ... ", 0);
                Exec.execCmd("rm -rf " + remoteExploreFile);
                Exec.execGetMerge(exp.getExpName(), remoteExploreFile);
                Logging.log("Done!", 0);
                Logging.log("Copying visual frame file from cloud server to local machine ... ", 0);
                ScpFrom.copyFromRemote(Config.SERVER_USER_NAME, Config.SERVER_HOST_NAME, remoteExploreFile, localExploreFile);
                Logging.log("Done!", 0);
                if (!Config.COMPRESS_VISUAL_FRAME_DATA) break block5;
                Logging.log("Uncompressing visual frame gzip file...", 0);
                if (CloudManager.gunzip(localExploreFile)) {
                    Logging.log("Done!", 0);
                    break block5;
                }
                Logging.log("Uncompress failed.", 2);
                return false;
            }
            catch (Exception ee) {
                Logging.log("Error building visual frame from cloud (" + ee.getMessage() + ")", 2);
                return false;
            }
        }
        return true;
    }

    public static boolean gunzip(String inFilePath) {
        try {
            int len;
            GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(inFilePath));
            String outFilePath = inFilePath.replace(".gz", "");
            FileOutputStream out = new FileOutputStream(outFilePath);
            byte[] buf = new byte[1024];
            while ((len = gzipInputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            gzipInputStream.close();
            ((OutputStream)out).close();
            new File(inFilePath).delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean downloadFileFromServer(String fileName) {
        String reqStr = String.valueOf(m_serverBase) + "?requesttype=hadoop.getfile";
        String absoluteName = String.valueOf(Config.REMOTE_WORKSPACE_ROOT) + fileName;
        try {
            BufferedInputStream in = new BufferedInputStream(new URL(reqStr).openStream());
            FileOutputStream fos = new FileOutputStream(absoluteName);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            System.out.print("Transfering file " + absoluteName + ".");
            while (in.read(data, 0, 1024) >= 0) {
                bout.write(data);
                System.out.print(".");
            }
            Logging.log("Done", 0);
            bout.close();
            in.close();
        }
        catch (Exception e) {
            Logging.log("Error downloading file " + fileName + " from hadoop server.", 2);
            return false;
        }
        return true;
    }

    public static String getHadoopJobStatus(String jobName) {
        String status = null;
        String reqStr = String.valueOf(m_serverBase) + "?requesttype=hadoop.status&jobName=" + jobName;
        status = CloudManager.cloudReader(reqStr);
        return status;
    }

    public static String getHadoopJobProgress(String jobName) {
        String progress = null;
        String reqStr = String.valueOf(m_serverBase) + "?requesttype=hadoop.progress&jobName=" + jobName;
        progress = CloudManager.cloudReader(reqStr);
        return progress;
    }

    public static String listExplorationsFromServer() {
        String reqStr = String.valueOf(m_serverBase) + "?requesttype=exploration.list";
        String exploreList = CloudManager.cloudReader(reqStr);
        return exploreList;
    }

    public static void main(String[] args) {
        CloudManager.gunzip("config.txt.gz");
    }

    class progressChecker
    extends Thread {
        progressChecker() {
        }

        @Override
        public void run() {
            MRProgressCheck.periodicCheck();
        }
    }
}

