/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.common;

import com.cloud.vista.common.Config;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class SystemSetting
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel panelConfig = null;
    private JPanel panelButton = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private JLabel lblLocalRoot = new JLabel("Local Workspace Directory:");
    private static JTextField txtLocalRoot = new JTextField();
    private JLabel lblCloudRoot = new JLabel("Server Workspace Directory:");
    private static JTextField txtCloudRoot = new JTextField();
    private JLabel lblCloudDataRoot = new JLabel("HDFS Dataset Root Directory:");
    private static JTextField txtCloudDataRoot = new JTextField();
    private JLabel lblPrivateKeyFile = new JLabel("Full Path to Private Key File:");
    private static JTextField txtPrivateKeyFile = new JTextField();
    private JLabel lblUserName = new JLabel("User Name for Server:");
    private static JTextField txtUserName = new JTextField();
    private JLabel lblHostName = new JLabel("Server Host Name:");
    private static JTextField txtHostName = new JTextField();
    private JLabel lblPort = new JLabel("Server Port Number:");
    private static JTextField txtPort = new JTextField();

    public SystemSetting() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setSize(550, 450);
        this.setDefaultCloseOperation(2);
        this.setTitle("System Settings");
        this.setResizable(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{250};
        int[] nArray = new int[3];
        nArray[0] = 509;
        nArray[1] = 40;
        gridBagLayout.rowHeights = nArray;
        gridBagLayout.columnWeights = new double[]{1.0};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.panelConfig = new JPanel();
        this.panelConfig.setBorder(new LineBorder(new Color(0, 0, 0)));
        GridBagConstraints gbc_panelConfig = new GridBagConstraints();
        gbc_panelConfig.insets = new Insets(10, 10, 10, 10);
        gbc_panelConfig.fill = 1;
        gbc_panelConfig.gridx = 0;
        gbc_panelConfig.gridy = 0;
        this.getContentPane().add((Component)this.panelConfig, gbc_panelConfig);
        GridBagLayout gbl_panelConfig = new GridBagLayout();
        gbl_panelConfig.columnWidths = new int[]{233, 271};
        int[] nArray2 = new int[8];
        nArray2[0] = 10;
        nArray2[1] = 10;
        nArray2[2] = 10;
        nArray2[3] = 10;
        nArray2[4] = 10;
        nArray2[5] = 10;
        nArray2[6] = 10;
        gbl_panelConfig.rowHeights = nArray2;
        gbl_panelConfig.columnWeights = new double[]{0.0, 0.0};
        gbl_panelConfig.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.panelConfig.setLayout(gbl_panelConfig);
        GridBagConstraints gbc_lblLocalRoot = new GridBagConstraints();
        gbc_lblLocalRoot.fill = 2;
        gbc_lblLocalRoot.insets = new Insets(0, 0, 5, 5);
        gbc_lblLocalRoot.gridx = 0;
        gbc_lblLocalRoot.gridy = 0;
        this.lblLocalRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblLocalRoot, gbc_lblLocalRoot);
        GridBagConstraints gbc_txtLocalRoot = new GridBagConstraints();
        gbc_txtLocalRoot.fill = 2;
        gbc_txtLocalRoot.insets = new Insets(0, 0, 5, 0);
        gbc_txtLocalRoot.gridx = 1;
        gbc_txtLocalRoot.gridy = 0;
        txtLocalRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtLocalRoot, gbc_txtLocalRoot);
        GridBagConstraints gbc_lblCloudRoot = new GridBagConstraints();
        gbc_lblCloudRoot.fill = 2;
        gbc_lblCloudRoot.insets = new Insets(0, 0, 5, 5);
        gbc_lblCloudRoot.gridx = 0;
        gbc_lblCloudRoot.gridy = 1;
        this.lblCloudRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblCloudRoot, gbc_lblCloudRoot);
        GridBagConstraints gbc_txtCloudRoot = new GridBagConstraints();
        gbc_txtCloudRoot.fill = 2;
        gbc_txtCloudRoot.insets = new Insets(0, 0, 5, 0);
        gbc_txtCloudRoot.gridx = 1;
        gbc_txtCloudRoot.gridy = 1;
        txtCloudRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtCloudRoot, gbc_txtCloudRoot);
        GridBagConstraints gbc_lblCloudDataRoot = new GridBagConstraints();
        gbc_lblCloudDataRoot.fill = 2;
        gbc_lblCloudDataRoot.insets = new Insets(0, 0, 5, 5);
        gbc_lblCloudDataRoot.gridx = 0;
        gbc_lblCloudDataRoot.gridy = 2;
        this.lblCloudDataRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblCloudDataRoot, gbc_lblCloudDataRoot);
        GridBagConstraints gbc_txtCloudDataRoot = new GridBagConstraints();
        gbc_txtCloudDataRoot.fill = 2;
        gbc_txtCloudDataRoot.insets = new Insets(0, 0, 5, 0);
        gbc_txtCloudDataRoot.gridx = 1;
        gbc_txtCloudDataRoot.gridy = 2;
        txtCloudDataRoot.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtCloudDataRoot, gbc_txtCloudDataRoot);
        GridBagConstraints gbc_lblPrivateKeyFile = new GridBagConstraints();
        gbc_lblPrivateKeyFile.fill = 2;
        gbc_lblPrivateKeyFile.insets = new Insets(0, 0, 5, 5);
        gbc_lblPrivateKeyFile.gridx = 0;
        gbc_lblPrivateKeyFile.gridy = 3;
        this.lblPrivateKeyFile.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblPrivateKeyFile, gbc_lblPrivateKeyFile);
        GridBagConstraints gbc_txtPrivateKeyFile = new GridBagConstraints();
        gbc_txtPrivateKeyFile.fill = 2;
        gbc_txtPrivateKeyFile.insets = new Insets(0, 0, 5, 0);
        gbc_txtPrivateKeyFile.gridx = 1;
        gbc_txtPrivateKeyFile.gridy = 3;
        txtPrivateKeyFile.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtPrivateKeyFile, gbc_txtPrivateKeyFile);
        GridBagConstraints gbc_lblUserName = new GridBagConstraints();
        gbc_lblUserName.fill = 2;
        gbc_lblUserName.insets = new Insets(0, 0, 5, 5);
        gbc_lblUserName.gridx = 0;
        gbc_lblUserName.gridy = 4;
        this.lblUserName.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblUserName, gbc_lblUserName);
        GridBagConstraints gbc_txtUserName = new GridBagConstraints();
        gbc_txtUserName.fill = 2;
        gbc_txtUserName.insets = new Insets(0, 0, 5, 0);
        gbc_txtUserName.gridx = 1;
        gbc_txtUserName.gridy = 4;
        txtUserName.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtUserName, gbc_txtUserName);
        GridBagConstraints gbc_lblHostName = new GridBagConstraints();
        gbc_lblHostName.fill = 2;
        gbc_lblHostName.insets = new Insets(0, 0, 5, 5);
        gbc_lblHostName.gridx = 0;
        gbc_lblHostName.gridy = 5;
        this.lblHostName.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblHostName, gbc_lblHostName);
        GridBagConstraints gbc_txtHostName = new GridBagConstraints();
        gbc_txtHostName.fill = 2;
        gbc_txtHostName.insets = new Insets(0, 0, 5, 0);
        gbc_txtHostName.gridx = 1;
        gbc_txtHostName.gridy = 5;
        txtHostName.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtHostName, gbc_txtHostName);
        GridBagConstraints gbc_lblPort = new GridBagConstraints();
        gbc_lblPort.fill = 2;
        gbc_lblPort.insets = new Insets(0, 0, 0, 5);
        gbc_lblPort.gridx = 0;
        gbc_lblPort.gridy = 6;
        this.lblPort.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)this.lblPort, gbc_lblPort);
        GridBagConstraints gbc_txtPort = new GridBagConstraints();
        gbc_txtPort.fill = 2;
        gbc_txtPort.gridx = 1;
        gbc_txtPort.gridy = 6;
        txtPort.setFont(new Font("Arial", 0, 15));
        this.panelConfig.add((Component)txtPort, gbc_txtPort);
        this.panelButton = new JPanel();
        GridBagConstraints gbc_panelButton = new GridBagConstraints();
        gbc_panelButton.insets = new Insets(10, 0, 10, 0);
        gbc_panelButton.fill = 3;
        gbc_panelButton.gridx = 0;
        gbc_panelButton.gridy = 1;
        this.getContentPane().add((Component)this.panelButton, gbc_panelButton);
        this.btnOK = new JButton("OK");
        this.btnOK.setFont(new Font("Tahoma", 0, 15));
        this.btnOK.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SystemSetting.saveSettings();
                Config.writeConfig();
                SystemSetting.this.dispose();
            }
        });
        this.panelButton.setLayout(new GridLayout(1, 5, 50, 0));
        this.panelButton.add(this.btnOK);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setFont(new Font("Tahoma", 0, 15));
        this.btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SystemSetting.this.dispose();
            }
        });
        this.panelButton.add(this.btnCancel);
        Config.readConfig();
        txtCloudDataRoot.setText(Config.REMOTE_HDFS_DATASET_ROOT);
        txtCloudRoot.setText(Config.REMOTE_WORKSPACE_ROOT);
        txtHostName.setText(Config.SERVER_HOST_NAME);
        txtLocalRoot.setText(Config.LOCAL_WORKSPACE_ROOT);
        txtPort.setText(Integer.toString(Config.SERVER_HOST_PORT));
        txtPrivateKeyFile.setText(Config.PRIVATE_KEY_FILE);
        txtUserName.setText(Config.SERVER_USER_NAME);
    }

    public static boolean saveSettings() {
        if (!txtLocalRoot.getText().equals("")) {
            Config.LOCAL_WORKSPACE_ROOT = txtLocalRoot.getText();
        }
        if (!txtCloudRoot.getText().equals("")) {
            Config.REMOTE_WORKSPACE_ROOT = txtCloudRoot.getText();
        }
        if (!txtCloudDataRoot.getText().equals("")) {
            Config.REMOTE_HDFS_DATASET_ROOT = txtCloudDataRoot.getText();
        }
        if (!txtPrivateKeyFile.getText().equals("")) {
            Config.PRIVATE_KEY_FILE = txtPrivateKeyFile.getText();
        }
        if (!txtUserName.getText().equals("")) {
            Config.SERVER_USER_NAME = txtUserName.getText();
        }
        if (!txtHostName.getText().equals("")) {
            Config.SERVER_HOST_NAME = txtHostName.getText();
        }
        if (!txtPort.getText().equals("")) {
            Config.SERVER_HOST_PORT = Integer.parseInt(txtPort.getText());
        }
        return true;
    }

    public static void main(String[] args) {
        SystemSetting ss = new SystemSetting();
        ss.setVisible(true);
    }
}

