/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.common;

import com.cloud.vista.common.Logging;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Config {
    public static String LOCAL_WORKSPACE_ROOT = "./";
    public static String REMOTE_WORKSPACE_ROOT = "/home/ada/cloud-vista/";
    public static String REMOTE_HDFS_DATASET_ROOT = "/user/kekechen/cloudvista/";
    public static String LOCAL_EXPLORATIONS_ROOT_DIR = String.valueOf(LOCAL_WORKSPACE_ROOT) + "/explorations/";
    public static String REMOTE_EXPLORATIONS_ROOT_DIR = String.valueOf(REMOTE_WORKSPACE_ROOT) + "/explorations/";
    public static String LOCAL_ROURCE_DIR = String.valueOf(LOCAL_WORKSPACE_ROOT) + "/resources/";
    public static String REMOTE_ROURCE_DIR = String.valueOf(REMOTE_WORKSPACE_ROOT) + "/resources/";
    public static String CONFIG_JSON_FILE_NAME = "config.json";
    public static String FRAME_DATA_FILE_NAME = "frames.data";
    public static String SERVER_JAR_FILE = String.valueOf(REMOTE_WORKSPACE_ROOT) + "/RR.jar";
    public static String PRIVATE_KEY_FILE = "/home/ada/.ssh/id_rsa";
    public static String SERVER_USER_NAME = "ada";
    public static String SERVER_PASSWORD = "";
    public static String SERVER_HOST_NAME = "nimbus.cs.wright.edu";
    public static int SERVER_HOST_PORT = 22;
    public static boolean COMPRESS_VISUAL_FRAME_DATA = true;
    public static int BUFFER_SIZE_BYTES = 1024;
    public static int MIN_FRAME_COUNT = 10;
    public static int MAX_FRAME_COUNT = 100;

    public static String getLocalJsonFileAbsolute(String dsName, String expName, String subExpName) {
        if (dsName.equals("") || expName.equals("")) {
            System.err.println("Dataset name or exploration name can't be empty! ");
            return "";
        }
        if (subExpName.equals("")) {
            return String.valueOf(LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + CONFIG_JSON_FILE_NAME;
        }
        return String.valueOf(LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + subExpName + "/" + CONFIG_JSON_FILE_NAME;
    }

    public static String getRemoteJsonFileAbsolute(String dsName, String expName, String subExpName) {
        if (dsName.equals("") || expName.equals("")) {
            System.err.println("Dataset name or exploration name can't be empty! ");
            return "";
        }
        if (subExpName.equals("")) {
            return String.valueOf(REMOTE_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + CONFIG_JSON_FILE_NAME;
        }
        return String.valueOf(REMOTE_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + subExpName + "/" + CONFIG_JSON_FILE_NAME;
    }

    public static String getLocalFrameFileAbsolute(String dsName, String expName, String subExpName) {
        if (dsName.equals("") || expName.equals("")) {
            System.err.println("Dataset name or exploration name can't be empty! ");
            return "";
        }
        if (subExpName.equals("")) {
            return String.valueOf(LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + FRAME_DATA_FILE_NAME;
        }
        return String.valueOf(LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + subExpName + "/" + FRAME_DATA_FILE_NAME;
    }

    public static String getRemoteFrameFileAbsolute(String dsName, String expName, String subExpName) {
        if (dsName.equals("") || expName.equals("")) {
            System.err.println("Dataset name or exploration name can't be empty! ");
            return "";
        }
        if (subExpName.equals("")) {
            return String.valueOf(REMOTE_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + FRAME_DATA_FILE_NAME;
        }
        return String.valueOf(REMOTE_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName + "/" + subExpName + "/" + FRAME_DATA_FILE_NAME;
    }

    public static boolean readConfig() {
        if (!new File(String.valueOf(LOCAL_WORKSPACE_ROOT) + "config.txt").exists()) {
            return false;
        }
        try {
            String line;
            FileInputStream fstream = new FileInputStream(String.valueOf(LOCAL_WORKSPACE_ROOT) + "config.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                String[] parts = line.trim().split("=");
                if (parts.length != 2 || parts[0].trim().equals("") || parts[1].trim().equals("")) continue;
                switch (parts[0].trim()) {
                    case "LOCAL_WORKSPACE_ROOT": {
                        LOCAL_WORKSPACE_ROOT = parts[1].trim();
                        break;
                    }
                    case "REMOTE_WORKSPACE_ROOT": {
                        REMOTE_WORKSPACE_ROOT = parts[1].trim();
                        break;
                    }
                    case "REMOTE_HDFS_DATASET_ROOT": {
                        REMOTE_HDFS_DATASET_ROOT = parts[1].trim();
                        break;
                    }
                    case "PRIVATE_KEY_FILE": {
                        PRIVATE_KEY_FILE = parts[1].trim();
                        break;
                    }
                    case "SERVER_USER_NAME": {
                        SERVER_USER_NAME = parts[1].trim();
                        break;
                    }
                    case "SERVER_HOST_NAME": {
                        SERVER_HOST_NAME = parts[1].trim();
                        break;
                    }
                    case "SERVER_HOST_PORT": {
                        SERVER_HOST_PORT = Integer.parseInt(parts[1].trim());
                    }
                }
            }
            in.close();
        }
        catch (Exception e) {
            Logging.log("Error reading from configuration file " + e.getMessage(), 2);
            return false;
        }
        return true;
    }

    public static boolean writeConfig() {
        File outFile = null;
        PrintWriter out = null;
        try {
            outFile = new File(String.valueOf(LOCAL_WORKSPACE_ROOT) + "config.txt");
            out = new PrintWriter(outFile);
            out.println("LOCAL_WORKSPACE_ROOT=" + LOCAL_WORKSPACE_ROOT);
            out.println("REMOTE_WORKSPACE_ROOT=" + REMOTE_WORKSPACE_ROOT);
            out.println("REMOTE_HDFS_DATASET_ROOT=" + REMOTE_HDFS_DATASET_ROOT);
            out.println("PRIVATE_KEY_FILE=" + PRIVATE_KEY_FILE);
            out.println("SERVER_USER_NAME=" + SERVER_USER_NAME);
            out.println("SERVER_HOST_NAME=" + SERVER_HOST_NAME);
            out.println("SERVER_HOST_PORT=" + SERVER_HOST_PORT);
            out.close();
        }
        catch (FileNotFoundException e) {
            Logging.log("Configuration writing to file error. ", 2);
        }
        return true;
    }

    public static void main(String[] args) {
        if (Config.readConfig()) {
            System.out.println(PRIVATE_KEY_FILE);
            Config.writeConfig();
        }
    }
}

