/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista.common;

import com.cloud.vista.Exploration;
import com.cloud.vista.common.Logging;
import com.cloud.vista.ui.VisualExplorer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BuildJson {
    public static boolean buildJsonFile(String fname, Exploration exp) {
        if (fname.equals("") || exp == null) {
            return false;
        }
        JSONObject obj = new JSONObject();
        try {
            int i;
            JSONArray aa;
            obj.put("dataset", (Object)exp.getDatasetName());
            obj.put("name", (Object)exp.getExpName());
            obj.put("ssname", (Object)exp.getExpSsName());
            obj.put("scale", (Object)new Double(exp.getScale()));
            obj.put("shiftx", (Object)new Double(exp.getShiftX()));
            obj.put("shifty", (Object)new Double(exp.getShiftY()));
            obj.put("op_type", (Object)exp.getExploreType());
            obj.put("step_length", (Object)new Double(exp.getStepLength()));
            obj.put("resolution", (Object)new Double(exp.getResolution()));
            obj.put("ndim", (Object)new Integer(exp.getDimension()));
            obj.put("nsteps", (Object)new Integer(exp.getNumFrames()));
            JSONArray nalpha = new JSONArray();
            double[] alpha = new double[exp.getDimension()];
            if (exp.getExploreType().equals("RR")) {
                aa = new JSONArray();
                i = 0;
                while (i < exp.getDimension()) {
                    alpha[i] = 0.5;
                    aa.put(0.5);
                    ++i;
                }
                exp.setNalphas(alpha, 0);
                nalpha.put((Object)aa);
            } else if (exp.getExploreType().equals("SS")) {
                obj.put("sample_rate", (Object)new Double(0.05));
                obj.put("max_samples", (Object)new Integer(50000));
                try {
                    obj.put("rescale", (Object)new Double(exp.getRescale()));
                }
                catch (Exception e) {
                    System.out.println("Can't get rescale, use default (1). ");
                    obj.put("rescale", (Object)new Double(1.0));
                }
                obj.put("xstart", exp.getXStart());
                obj.put("xend", exp.getXEnd());
                obj.put("ystart", exp.getYStart());
                obj.put("yend", exp.getYEnd());
                aa = new JSONArray();
                alpha = exp.getAlpha(VisualExplorer.currentViewID);
                i = 0;
                while (i < exp.getDimension()) {
                    aa.put(alpha[i]);
                    ++i;
                }
                exp.setNalphas(alpha, 0);
                nalpha.put((Object)aa);
            }
            Random r = new Random();
            i = 1;
            while (i < exp.getNumFrames()) {
                JSONArray aa2 = new JSONArray();
                int j = 0;
                while (j < exp.getDimension()) {
                    alpha[j] = (double)(r.nextInt(3) - 1) * exp.getStepLength() + alpha[j];
                    if (alpha[j] < -1.0) {
                        alpha[j] = -1.0;
                    }
                    if (alpha[j] > 1.0) {
                        alpha[j] = 1.0;
                    }
                    aa2.put(alpha[j]);
                    ++j;
                }
                exp.setNalphas(alpha, i);
                nalpha.put((Object)aa2);
                ++i;
            }
            obj.put("nalpha", (Object)nalpha);
        }
        catch (JSONException e1) {
            Logging.log("Failed in building json file. ", 2);
            return false;
        }
        try {
            String jsonText = obj.toString(4);
            BufferedWriter op = new BufferedWriter(new FileWriter(fname));
            op.write(jsonText, 0, jsonText.length());
            op.close();
            Logging.log("Successfully write parameters to json file " + fname, 0);
        }
        catch (IOException e) {
            Logging.log("Writing parameters failed - " + e.getMessage(), 2);
            return false;
        }
        catch (JSONException e) {
            Logging.log("Json object to string error - " + e.getMessage(), 2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Exploration exp = new Exploration("kddcup.big.std", "test.1", "");
        String fname = exp.getLocalJsonFile();
        BuildJson.buildJsonFile(fname, exp);
    }
}

