/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista;

import com.cloud.vista.ui.VisualExplorer;
import com.cloud.vista.widgets.Point;
import java.awt.Color;
import java.util.ArrayList;

public class VisualFrame {
    private int m_visualFrameID = 0;
    private ArrayList<Point> m_visualFramePoints = null;

    public VisualFrame(int vid) {
        this.m_visualFrameID = vid;
        this.m_visualFramePoints = new ArrayList();
    }

    public VisualFrame() {
    }

    public int getVisualFrameID() {
        return this.m_visualFrameID;
    }

    public int getNumPoints() {
        return this.m_visualFramePoints.size();
    }

    public ArrayList<Point> getVisualFramePoints() {
        return this.m_visualFramePoints;
    }

    public void setVisualFrameID(int vid) {
        this.m_visualFrameID = vid;
    }

    public void addPoint(Point pt) {
        this.m_visualFramePoints.add(pt);
    }

    void normalize(float md, float td) {
        Point p;
        float mean = td / (float)this.m_visualFramePoints.size();
        float var = 0.0f;
        float dense = 0.0f;
        int i = 0;
        while (i < this.m_visualFramePoints.size()) {
            p = this.m_visualFramePoints.get(i);
            var += (p.getPointDensity() - mean) * (p.getPointDensity() - mean);
            ++i;
        }
        var = (float)Math.sqrt(var / (float)this.m_visualFramePoints.size()) / 25.0f;
        i = 0;
        while (i < this.m_visualFramePoints.size()) {
            p = this.m_visualFramePoints.get(i);
            dense = (p.getPointDensity() - mean) / var;
            p.setPointColor(this.renderPointColor(dense));
            ++i;
        }
    }

    public Color renderPointColor(float val) {
        val = -val;
        float mid = 0.4f;
        float vv = Math.abs(val);
        val = val < 0.0f ? mid - mid * vv : mid + (1.0f - mid) * vv;
        float r = 0.0f;
        float b = 0.0f;
        float g = 0.0f;
        if (val < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        switch ((int)((double)val / 0.2)) {
            case 0: {
                r = 255.0f;
                b = (float)(0.0 + 255.0 * ((double)val % 0.2) / 0.2);
                g = 0.0f;
                break;
            }
            case 1: {
                r = (float)(255.0 - 255.0 * ((double)val % 0.2) / 0.2);
                b = 255.0f;
                g = 0.0f;
                break;
            }
            case 2: {
                r = 0.0f;
                b = 255.0f;
                g = (float)(0.0 + 200.0 * ((double)val % 0.2) / 0.2);
                break;
            }
            case 3: {
                r = 100.0f;
                b = (float)(255.0 - 255.0 * ((double)val % 0.2) / 0.2);
                g = (float)(150.0 + 105.0 * ((double)val % 0.2) / 0.2);
                break;
            }
            case 4: {
                r = (float)(105.0 - 105.0 * ((double)val % 0.2) / 0.2);
                b = 0.0f;
                g = (float)(105.0 - 105.0 * ((double)val % 0.2) / 0.2);
                break;
            }
            case 5: {
                r = 0.0f;
                b = 0.0f;
                g = 25.0f;
            }
        }
        return new Color((int)r, (int)g, (int)b);
    }

    public int count(int xstart, int ystart, int xend, int yend) {
        int cnt = 0;
        int i = 0;
        while (i < this.m_visualFramePoints.size()) {
            Point p = this.m_visualFramePoints.get(i);
            int x = (int)(p.getPointX() * (float)VisualExplorer.getResolution() + 500.0f);
            int y = (int)(p.getPointY() * (float)VisualExplorer.getResolution() + 500.0f);
            if (x >= xstart && x <= xend && y >= ystart && y <= yend) {
                cnt = (int)((float)cnt + p.getPointDensity());
            }
            ++i;
        }
        return cnt;
    }

    public Point computeCenter() {
        Point p;
        int x = 0;
        int y = 0;
        boolean maxDensity = false;
        int i = 0;
        while (i < this.getNumPoints()) {
            p = this.m_visualFramePoints.get(i);
            x = (int)((float)x + p.getPointX());
            y = (int)((float)y + p.getPointY());
            if (p.getPointDensity() > (float)maxDensity) {
                x = (int)p.getPointX() / 2;
                y = (int)p.getPointY() / 2;
            }
            ++i;
        }
        p = new Point(Integer.toString(x), Integer.toString(y), "1");
        return p;
    }
}

