/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista;

import com.cloud.vista.VisualFrame;
import com.cloud.vista.common.Config;
import com.cloud.vista.common.Logging;
import com.cloud.vista.common.Tools;
import com.cloud.vista.mapred.CloudManager;
import com.cloud.vista.widgets.Point;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class Exploration {
    private HashMap<Integer, VisualFrame> visualFrames = new HashMap();
    private String expName = "explore.sample";
    private String expSsName = "";
    private String datasetName = "";
    private double scale = 30.0;
    private double shiftx = 0.0;
    private double shifty = 0.0;
    private String op_type = "RR";
    private double step_length = 0.05;
    private double resolution = 1.0;
    private int numFrames = 10;
    private int dimension = 68;
    private double rescale = 1.0;
    private double xstart = -100.0;
    private double ystart = -100.0;
    private double xend = 100.0;
    private double yend = 100.0;
    private double[][] nalphas = new double[this.getNumFrames()][this.getDimension()];

    public String getFullName() {
        String fullName = this.getDatasetName();
        fullName = String.valueOf(fullName) + "|" + this.getExpName();
        return this.isSubSetExp() ? String.valueOf(fullName) + "|" + this.getExpSsName() : fullName;
    }

    public String getExpName() {
        return this.expName;
    }

    public void setExpName(String name) {
        this.expName = name;
    }

    public String getExpSsName() {
        return this.expSsName;
    }

    public void setExpSsName(String name) {
        this.expSsName = name;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getHdfsDatasetName() {
        return String.valueOf(Config.REMOTE_HDFS_DATASET_ROOT) + this.datasetName;
    }

    public void setDatasetName(String name) {
        this.datasetName = name;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getShiftX() {
        return this.shiftx;
    }

    public void setShiftX(double sx) {
        this.shiftx = sx;
    }

    public double getShiftY() {
        return this.shifty;
    }

    public void setShiftY(double sy) {
        this.shifty = sy;
    }

    public String getExploreType() {
        return this.op_type;
    }

    public void setExploreType(String type) {
        this.op_type = type;
    }

    public double getStepLength() {
        return this.step_length;
    }

    public void setStepLength(double sl) {
        this.step_length = sl;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double r) {
        this.resolution = r;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int s) {
        if (this.numFrames >= Config.MIN_FRAME_COUNT && this.numFrames <= Config.MAX_FRAME_COUNT) {
            this.numFrames = s;
        } else {
            Logging.log("Frame number must be between " + Config.MIN_FRAME_COUNT + " and " + Config.MAX_FRAME_COUNT, 1);
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dim) {
        this.dimension = dim;
    }

    public double getRescale() {
        return this.rescale;
    }

    public void setRescale(double rs) {
        this.rescale = rs;
    }

    public double getXStart() {
        return this.xstart;
    }

    public void setXStart(double xs) {
        this.xstart = xs;
    }

    public double getYStart() {
        return this.ystart;
    }

    public void setYStart(double ys) {
        this.ystart = ys;
    }

    public double getXEnd() {
        return this.xend;
    }

    public void setXEnd(double xe) {
        this.xend = xe;
    }

    public double getYEnd() {
        return this.yend;
    }

    public void setYEnd(double ye) {
        this.yend = ye;
    }

    public double[][] getNalphas() {
        return this.nalphas;
    }

    public double[] getAlpha(int row) {
        double[] alpha = new double[this.getDimension()];
        int i = 0;
        while (i < this.getDimension()) {
            alpha[i] = this.nalphas[row][i];
            ++i;
        }
        return alpha;
    }

    public void setNalphas(double[] alpha, int row) {
        int i = 0;
        while (i < this.getDimension()) {
            this.nalphas[row][i] = alpha[i];
            ++i;
        }
    }

    public void setNalphas(double[][] alphas) {
        this.nalphas = alphas;
    }

    public void initNalphas() {
        int i = 0;
        while (i < this.getDimension()) {
            this.nalphas[0][i] = 0.5;
            ++i;
        }
        Random r = new Random();
        int i2 = 1;
        while (i2 < this.getNumFrames()) {
            int j = 0;
            while (j < this.getDimension()) {
                this.nalphas[i2][j] = (double)(r.nextInt(3) - 1) * this.getStepLength() + this.nalphas[i2 - 1][j];
                if (this.nalphas[i2][j] < -1.0) {
                    this.nalphas[i2][j] = -1.0;
                }
                if (this.nalphas[i2][j] > 1.0) {
                    this.nalphas[i2][j] = 1.0;
                }
                ++j;
            }
            ++i2;
        }
    }

    public Exploration(String dsName, String expName, String expSsName) {
        String expDir = "";
        expDir = String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + dsName + "/" + expName;
        this.setDatasetName(dsName);
        this.setExpName(expName);
        if (expSsName == null) {
            expSsName = "";
        }
        if (!expSsName.equals("")) {
            expDir = String.valueOf(expDir) + "/" + expSsName;
            this.setExpSsName(expSsName);
        }
        this.initNalphas();
        if (!new File(expDir).exists()) {
            new File(expDir).mkdirs();
        } else {
            Logging.log("Exploration name " + expName + " already exists, ignoring.", 1);
        }
    }

    public boolean isSubSetExp() {
        return !this.getExpSsName().equals("");
    }

    public String getLocalExpRoot() {
        String dir = String.valueOf(Config.LOCAL_EXPLORATIONS_ROOT_DIR) + this.getDatasetName() + "/" + this.getExpName() + "/";
        if (this.isSubSetExp()) {
            dir = String.valueOf(dir) + this.getExpSsName() + "/";
        }
        return dir;
    }

    public String getRemoteExpRoot() {
        String dir = String.valueOf(Config.REMOTE_EXPLORATIONS_ROOT_DIR) + this.getDatasetName() + "/" + this.getExpName() + "/";
        if (this.isSubSetExp()) {
            dir = String.valueOf(dir) + this.getExpSsName() + "/";
        }
        return dir;
    }

    public String getLocalJsonFile() {
        return String.valueOf(this.getLocalExpRoot()) + Config.CONFIG_JSON_FILE_NAME;
    }

    public String getRemoteJsonFile() {
        return String.valueOf(this.getRemoteExpRoot()) + Config.CONFIG_JSON_FILE_NAME;
    }

    public String getLocalDataFileName() {
        return String.valueOf(this.getLocalExpRoot()) + Config.FRAME_DATA_FILE_NAME;
    }

    public String getRemoteDataFileName() {
        return String.valueOf(this.getRemoteExpRoot()) + Config.FRAME_DATA_FILE_NAME;
    }

    public boolean create() {
        return new File(this.getLocalExpRoot()).mkdirs();
    }

    public boolean deleteDataFile() {
        File dataFile = new File(this.getLocalDataFileName());
        if (dataFile.exists()) {
            return dataFile.delete();
        }
        return false;
    }

    public boolean deleteJsonFile() {
        File jsonFile = new File(this.getLocalJsonFile());
        if (jsonFile.exists()) {
            return jsonFile.delete();
        }
        return false;
    }

    public boolean build() {
        if (!new File(this.getLocalDataFileName()).exists()) {
            CloudManager.buildExploreAndFetchFile(this);
        }
        return this.renderVisualFrames(this.getLocalDataFileName());
    }

    public boolean renderVisualFrames(String fileFullName) {
        File file = null;
        FileInputStream fstream = null;
        DataInputStream in = null;
        float maxdense = 0.0f;
        byte[] fileBytes = null;
        if (!new File(fileFullName).exists()) {
            System.err.println("File " + fileFullName + " doesn't exist. ");
            return false;
        }
        try {
            file = new File(fileFullName);
            fstream = new FileInputStream(fileFullName);
            in = new DataInputStream(fstream);
            fileBytes = new byte[(int)file.length()];
            in.readFully(fileBytes);
            VisualFrame v = new VisualFrame(0);
            float dense = 0.0f;
            String[] stringArray = new String(fileBytes, "UTF-8").trim().split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    Point p;
                    int vid;
                    int vid0;
                    String[] p2;
                    String[] p1;
                    String oneLine = stringArray[n2];
                    try {
                        p1 = oneLine.trim().split("\t");
                        p2 = p1[0].trim().split("[|]");
                        vid0 = v.getVisualFrameID();
                        vid = Exploration.parseInt(p2[0]);
                    }
                    catch (Exception e) {
                        break block8;
                    }
                    if (vid0 != vid) {
                        v.normalize(maxdense, dense);
                        Logging.log("Added visual frame with ID: " + v.getVisualFrameID(), 0);
                        Logging.log(" Number of points in frame: " + v.getNumPoints(), 0);
                        this.visualFrames.put(v.getVisualFrameID(), v);
                        dense = 0.0f;
                        maxdense = 0.0f;
                        v = new VisualFrame(vid);
                    }
                    if ((p = new Point(Exploration.parseInt(p2[1]), Exploration.parseInt(p2[2]), Exploration.parseInt(p1[1]))).getPointDensity() > maxdense) {
                        maxdense = p.getPointDensity();
                    }
                    dense += p.getPointDensity();
                    v.addPoint(p);
                }
                ++n2;
            }
            v.normalize(maxdense, dense);
            this.visualFrames.put(v.getVisualFrameID(), v);
            this.setNumFrames(this.visualFrames.size());
            in.close();
        }
        catch (Exception e) {
            Logging.log("Error reading from file " + e.getMessage(), 2);
            return false;
        }
        return true;
    }

    public static int parseInt(String s) {
        int num = 0;
        int sign = -1;
        int len = s.length();
        char ch = s.charAt(0);
        if (ch == '-') {
            sign = 1;
        } else {
            num = 48 - ch;
        }
        int i = 1;
        while (i < len) {
            num = num * 10 + 48 - s.charAt(i++);
        }
        return sign * num;
    }

    public static float parseFloat(String f) {
        int len = f.length();
        float ret = 0.0f;
        int pos = 0;
        int part = 0;
        boolean neg = false;
        while (pos < len && (f.charAt(pos) < '0' || f.charAt(pos) > '9') && f.charAt(pos) != '-' && f.charAt(pos) != '.') {
            ++pos;
        }
        if (f.charAt(pos) == '-') {
            neg = true;
            ++pos;
        }
        while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
            part = part * 10 + (f.charAt(pos++) - 48);
        }
        float f2 = ret = neg ? (float)(part * -1) : (float)part;
        if (pos < len && f.charAt(pos) == '.') {
            ++pos;
            int mul = 1;
            part = 0;
            while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
                part = part * 10 + (f.charAt(pos) - 48);
                mul *= 10;
                ++pos;
            }
            float f3 = ret = neg ? ret - (float)part / (float)mul : ret + (float)part / (float)mul;
        }
        if (pos < len && (f.charAt(pos) == 'e' || f.charAt(pos) == 'E')) {
            neg = f.charAt(++pos) == '-';
            ++pos;
            part = 0;
            while (pos < len && f.charAt(pos) <= '9' && f.charAt(pos) >= '0') {
                part = part * 10 + (f.charAt(pos++) - 48);
            }
            ret = neg ? (ret /= (float)Math.pow(10.0, part)) : (ret *= (float)Math.pow(10.0, part));
        }
        return ret;
    }

    public VisualFrame getVisualFrame(int vid) {
        return this.visualFrames.get(vid);
    }

    public int getActualFrameCnt() {
        return this.visualFrames.size();
    }

    public static void main(String[] args) {
        Exploration.speedTest("frames.data");
    }

    public boolean delete() {
        File expDir = new File(this.getLocalExpRoot());
        if (expDir.exists() && Tools.promptYesNo("Are you sure to delete exploration " + this.getFullName())) {
            File[] files;
            File[] fileArray = files = expDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.delete()) {
                    Logging.log("Deleted file " + f.getName(), 0);
                }
                ++n2;
            }
            return expDir.delete();
        }
        return false;
    }

    public static void speedTest(String fileFullName) {
        FileInputStream fstream = null;
        DataInputStream in = null;
        BufferedReader reader = null;
        if (!new File(fileFullName).exists()) {
            System.err.println("File " + fileFullName + " doesn't exist. ");
        }
        try {
            fstream = new FileInputStream(fileFullName);
            in = new DataInputStream(fstream);
            reader = new BufferedReader(new InputStreamReader(in), Config.BUFFER_SIZE_BYTES);
        }
        catch (Exception e) {
            System.out.println("Error reading from file " + e.getMessage());
        }
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            try {
                String line;
                do {
                    line = reader.readLine();
                    list.add(line);
                } while (line != null && line != "");
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

