/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.vista;

import com.cloud.vista.common.Config;
import com.cloud.vista.mapred.MRProgressBar;
import com.cloud.vista.ui.ExploreManager;
import com.cloud.vista.ui.VisualOperation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CloudVista
extends JFrame {
    private static final long serialVersionUID = 154648645L;
    public static ExploreManager exploreManager = null;
    public static MRProgressBar windowProgress = null;
    public static VisualOperation operator = null;
    public static int managerWidth = 200;

    public CloudVista() {
        super("The Cloud Vista Demo System.");
        this.setUndecorated(true);
        this.setExtendedState(6);
        this.setDefaultCloseOperation(3);
        Config.readConfig();
        JPanel rootPane = new JPanel();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        JPanel visualPane = new JPanel();
        visualPane.setLayout(null);
        operator = new VisualOperation(dim.width - managerWidth, dim.height);
        visualPane.add(operator);
        GridBagLayout gbl_rootPane = new GridBagLayout();
        gbl_rootPane.columnWidths = new int[]{dim.width - managerWidth, managerWidth};
        int[] nArray = new int[2];
        nArray[0] = dim.height;
        gbl_rootPane.rowHeights = nArray;
        gbl_rootPane.columnWeights = new double[]{1.0, 1.0};
        gbl_rootPane.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        rootPane.setLayout(gbl_rootPane);
        exploreManager = new ExploreManager(managerWidth, dim.height);
        GridBagConstraints gbc_visualPane = new GridBagConstraints();
        gbc_visualPane.gridheight = 1;
        gbc_visualPane.gridwidth = 1;
        gbc_visualPane.insets = new Insets(5, 0, 5, 0);
        gbc_visualPane.fill = 1;
        gbc_visualPane.gridx = 0;
        gbc_visualPane.gridy = 0;
        rootPane.add((Component)visualPane, gbc_visualPane);
        GridBagConstraints gbc_exploreManager = new GridBagConstraints();
        gbc_exploreManager.gridheight = 1;
        gbc_exploreManager.gridwidth = 1;
        gbc_exploreManager.fill = 1;
        gbc_exploreManager.insets = new Insets(5, 0, 5, 0);
        gbc_exploreManager.gridx = 1;
        gbc_exploreManager.gridy = 0;
        rootPane.add((Component)exploreManager, gbc_exploreManager);
        this.setContentPane(rootPane);
        this.pack();
        this.setVisible(true);
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                VisualOperation.visualWindow.exit();
            }
        });
    }

    public static void main(String[] args) {
        new CloudVista();
    }
}

