/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.IOException;
import java.util.ArrayList;
import processing.app.Base;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;
import processing.mode.android.AndroidSDK;

public class AVD {
    private static final String AVD_CREATE_PRIMARY = "An error occurred while running \u201candroid create avd\u201d";
    private static final String AVD_CREATE_SECONDARY = "The default Android emulator could not be set up. Make sure<br>that the Android SDK is installed properly, and that the<br>Android and Google APIs are installed for level 7.<br>(Between you and me, occasionally, this error is a red herring,<br>and your sketch may be launching shortly.)";
    private static final String AVD_LOAD_PRIMARY = "There is an error with the Processing AVD.";
    private static final String AVD_LOAD_SECONDARY = "This could mean that the Android tools need to be updated,<br>or that the Processing AVD should be deleted (it will<br>automatically re-created the next time you run Processing).<br>Open the Android SDK manager to check for any errors.";
    private static final String AVD_TARGET_PRIMARY = "The Google APIs are not installed properly";
    private static final String AVD_TARGET_SECONDARY = "Please re-read the installation instructions for Processing<br>found at http://android.processing.org and try again.";
    static final String DEFAULT_SKIN = "WVGA800";
    protected String name;
    protected String target;
    public static final AVD defaultAVD = new AVD("Processing-0197", "Google Inc.:Google APIs:7");
    static ArrayList<String> avdList;
    static ArrayList<String> badList;

    public AVD(String name, String target) {
        this.name = name;
        this.target = target;
    }

    protected static void list(AndroidSDK sdk) throws IOException {
        try {
            avdList = new ArrayList();
            badList = new ArrayList();
            ProcessResult listResult = new ProcessHelper(sdk.getAndroidToolPath(), "list", "avds").execute();
            if (listResult.succeeded()) {
                boolean badness = false;
                for (String line : listResult) {
                    String[] m = PApplet.match((String)line, (String)"\\s+Name\\:\\s+(\\S+)");
                    if (m != null) {
                        if (!badness) {
                            avdList.add(m[1]);
                        } else {
                            badList.add(m[1]);
                        }
                    }
                    if (!line.contains("could not be loaded:")) continue;
                    badness = true;
                }
            } else {
                System.err.println("Unhappy inside exists()");
                System.err.println(listResult);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean exists(AndroidSDK sdk) throws IOException {
        if (avdList == null) {
            AVD.list(sdk);
        }
        for (String avd : avdList) {
            if (!avd.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    protected boolean badness() {
        for (String avd : badList) {
            if (!avd.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    protected boolean create(AndroidSDK sdk) throws IOException {
        String[] params = new String[]{sdk.getAndroidToolPath(), "create", "avd", "-n", this.name, "-t", this.target, "-c", "64M", "-s", DEFAULT_SKIN};
        ProcessHelper p = new ProcessHelper(params);
        try {
            ProcessResult createAvdResult = p.execute();
            if (createAvdResult.succeeded()) {
                return true;
            }
            if (createAvdResult.toString().contains("Target id is not valid")) {
                Base.showWarningTiered("Android Error", AVD_TARGET_PRIMARY, AVD_TARGET_SECONDARY, null);
            } else {
                Base.showWarningTiered("Android Error", AVD_CREATE_PRIMARY, AVD_CREATE_SECONDARY, null);
                System.out.println(createAvdResult);
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return false;
    }

    public static boolean ensureEclairAVD(AndroidSDK sdk) {
        try {
            if (defaultAVD.exists(sdk)) {
                return true;
            }
            if (defaultAVD.badness()) {
                Base.showWarningTiered("Android Error", AVD_LOAD_PRIMARY, AVD_LOAD_SECONDARY, null);
                return false;
            }
            if (defaultAVD.create(sdk)) {
                return true;
            }
        }
        catch (Exception e) {
            Base.showWarningTiered("Android Error", AVD_CREATE_PRIMARY, AVD_CREATE_SECONDARY, null);
        }
        return false;
    }
}

