/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.RunnerException;
import processing.app.preproc.PdePreprocessor;
import processing.app.preproc.PreprocessResult;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
extends PdePreprocessor {
    Sketch sketch;
    String packageName;
    String sizeStatement;
    String sketchWidth;
    String sketchHeight;
    String sketchRenderer;

    public Preprocessor(Sketch sketch, String string) throws IOException {
        super(sketch.getName());
        this.sketch = sketch;
        this.packageName = string;
    }

    protected boolean parseSketchSize() {
        String string = Sketch.scrubComments((String)this.sketch.getCode(0).getProgram());
        String[] stringArray = PApplet.match((String)string, (String)"(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;");
        if (stringArray != null) {
            boolean bl = false;
            if (!stringArray[1].equals("screenWidth") && !stringArray[1].equals("screenHeight") && PApplet.parseInt((String)stringArray[1], (int)-1) == -1) {
                bl = true;
            }
            if (!stringArray[2].equals("screenWidth") && !stringArray[2].equals("screenHeight") && PApplet.parseInt((String)stringArray[2], (int)-1) == -1) {
                bl = true;
            }
            if (bl) {
                Base.showWarning("Could not find sketch size", "The size of this applet could not automatically be determined\nfrom your code. Use only numeric values (not variables) for the\nsize() command. See the size() reference for more information.", null);
                System.out.println("More about the size() command on Android can be");
                System.out.println("found here: http://wiki.processing.org/w/Android");
                return false;
            }
            this.sizeStatement = stringArray[0];
            this.sketchWidth = stringArray[1];
            this.sketchHeight = stringArray[2];
            this.sketchRenderer = stringArray[3].trim();
            if (this.sketchRenderer.length() == 0) {
                this.sketchRenderer = null;
            }
        } else {
            this.sizeStatement = null;
            this.sketchWidth = null;
            this.sketchHeight = null;
            this.sketchRenderer = null;
        }
        return true;
    }

    @Override
    public PreprocessResult write(Writer writer, String string, String[] stringArray) throws RunnerException, RecognitionException, TokenStreamException {
        if (this.sizeStatement != null) {
            int n = string.indexOf(this.sizeStatement);
            string = string.substring(0, n) + string.substring(n + this.sizeStatement.length());
        }
        string = string.replaceAll("import\\s+processing\\.opengl\\.\\S+;", "");
        return super.write(writer, string, stringArray);
    }

    @Override
    protected int writeImports(PrintWriter printWriter, List<String> list, List<String> list2) {
        printWriter.println("package " + this.packageName + ";");
        printWriter.println();
        return 2 + super.writeImports(printWriter, list, list2);
    }

    @Override
    protected void writeFooter(PrintWriter printWriter, String string) {
        if (this.mode == PdePreprocessor.Mode.STATIC) {
            printWriter.println("noLoop();");
            printWriter.println(this.indent + "}");
        }
        if (this.mode == PdePreprocessor.Mode.STATIC || this.mode == PdePreprocessor.Mode.ACTIVE) {
            printWriter.println();
            if (this.sketchWidth != null) {
                printWriter.println(this.indent + "public int sketchWidth() { return " + this.sketchWidth + "; }");
            }
            if (this.sketchHeight != null) {
                printWriter.println(this.indent + "public int sketchHeight() { return " + this.sketchHeight + "; }");
            }
            if (this.sketchRenderer != null) {
                printWriter.println(this.indent + "public String sketchRenderer() { return " + this.sketchRenderer + "; }");
            }
            printWriter.println("}");
        }
    }

    @Override
    public String[] getCoreImports() {
        return new String[]{"processing.core.*", "processing.xml.*"};
    }

    @Override
    public String[] getDefaultImports() {
        String string = Preferences.get("android.preproc.imports.list");
        if (string != null) {
            return PApplet.splitTokens((String)string, (String)", ");
        }
        String[] stringArray = new String[]{"android.view.MotionEvent", "android.view.KeyEvent", "android.graphics.Bitmap", "java.io.*", "java.util.*"};
        Preferences.set("android.preproc.imports.list", PApplet.join((String[])stringArray, (String)","));
        return stringArray;
    }
}

