/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.tools.android.AndroidMode;
import processing.core.PApplet;
import processing.xml.XMLElement;

public class Manifest {
    static final String MANIFEST_XML = "AndroidManifest.xml";
    static final String WORLD_OF_HURT_COMING = "Errors occurred while reading or writing AndroidManifest.xml,\nwhich means lots of things are likely to stop working properly.\nTo prevent losing any data, it's recommended that you use \u201cSave As\u201d\nto save a separate copy of your sketch, and the restart Processing.";
    static final String MULTIPLE_ACTIVITIES = "Processing only supports a single Activity in the AndroidManifest.xml\nfile. Only the first activity entry will be updated, and you better \nhope that's the right one, smartypants.";
    private Editor editor;
    private Sketch sketch;
    private XMLElement xml;
    static final String PERMISSION_PREFIX = "android.permission.";

    public Manifest(Editor editor) {
        this.editor = editor;
        this.sketch = editor.getSketch();
        this.load();
    }

    private String defaultPackageName() {
        Sketch sketch = this.editor.getSketch();
        return "processing.android.test." + sketch.getName().toLowerCase();
    }

    public String getPackageName() {
        String string = this.xml.getString("package");
        return string.length() == 0 ? this.defaultPackageName() : string;
    }

    public void setPackageName(String string) {
        this.xml.setString("package", string);
        this.save();
    }

    public String[] getPermissions() {
        XMLElement[] xMLElementArray = this.xml.getChildren("uses-permission");
        int n = xMLElementArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = xMLElementArray[i].getString("android:name").substring(PERMISSION_PREFIX.length());
        }
        return stringArray;
    }

    public void setPermissions(String[] stringArray) {
        for (XMLElement xMLElement : this.xml.getChildren("uses-permission")) {
            this.xml.removeChild(xMLElement);
        }
        for (String string : stringArray) {
            XMLElement xMLElement = new XMLElement("uses-permission");
            xMLElement.setString("android:name", PERMISSION_PREFIX + string);
            this.xml.addChild(xMLElement);
        }
        this.save();
    }

    public void setClassName(String string) {
        XMLElement xMLElement;
        String string2;
        XMLElement[] xMLElementArray = this.xml.getChildren("application/activity");
        if (xMLElementArray.length != 1) {
            Base.showWarning("Don't touch that", MULTIPLE_ACTIVITIES, null);
        }
        if ((string2 = (xMLElement = xMLElementArray[0]).getString("android:name")) == null || !string2.equals(string)) {
            xMLElement.setString("android:name", "." + string);
            this.save();
        }
    }

    private void writeBlankManifest(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\" ");
        printWriter.println("          package=\"\" ");
        printWriter.println("          android:versionCode=\"1\" ");
        printWriter.println("          android:versionName=\"1.0\">");
        printWriter.println("  <uses-sdk android:minSdkVersion=\"7\" />");
        printWriter.println("  <application android:label=\"\"");
        printWriter.println("               android:icon=\"@drawable/icon\"");
        printWriter.println("               android:debuggable=\"true\">");
        printWriter.println("    <activity android:name=\"\">");
        printWriter.println("      <intent-filter>");
        printWriter.println("        <action android:name=\"android.intent.action.MAIN\" />");
        printWriter.println("        <category android:name=\"android.intent.category.LAUNCHER\" />");
        printWriter.println("      </intent-filter>");
        printWriter.println("    </activity>");
        printWriter.println("  </application>");
        printWriter.println("</manifest>");
        printWriter.flush();
        printWriter.close();
    }

    protected void writeBuild(File file, String string, boolean bl) throws IOException {
        XMLElement xMLElement;
        String string2;
        this.save(file);
        XMLElement xMLElement2 = new XMLElement((Reader)new FileReader(file));
        String string3 = xMLElement2.getString("package").trim();
        if (string3.length() == 0) {
            xMLElement2.setString("package", this.defaultPackageName());
        }
        if ((string2 = (xMLElement = xMLElement2.getChild("application")).getString("android:label")).length() == 0) {
            xMLElement.setString("android:label", string);
        }
        xMLElement.setString("android:debuggable", bl ? "true" : "false");
        XMLElement xMLElement3 = xMLElement.getChild("activity");
        xMLElement3.setString("android:name", "." + string);
        PrintWriter printWriter = PApplet.createWriter((File)file);
        xMLElement2.write(printWriter);
        printWriter.close();
    }

    protected void load() {
        File file;
        block7: {
            file = this.getManifestFile();
            if (file.exists()) {
                try {
                    this.xml = new XMLElement((Reader)new FileReader(file));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Problem reading AndroidManifest.xml, creating a new version");
                    long l = file.lastModified();
                    String string = AndroidMode.getDateStamp(l);
                    File file2 = new File(this.sketch.getFolder(), "AndroidManifest.xml." + string);
                    boolean bl = file.renameTo(file2);
                    if (bl) break block7;
                    System.err.println("Could not move/rename " + file.getAbsolutePath());
                    System.err.println("You'll have to move or remove it before continuing.");
                    return;
                }
            }
        }
        if (this.xml == null) {
            this.writeBlankManifest(file);
            try {
                this.xml = new XMLElement((Reader)new FileReader(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Could not read " + file.getAbsolutePath());
                fileNotFoundException.printStackTrace();
            }
        }
        if (this.xml == null) {
            Base.showWarning("Error handling AndroidManifest.xml", WORLD_OF_HURT_COMING, null);
        }
    }

    protected void save() {
        this.save(this.getManifestFile());
    }

    protected void save(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        this.xml.write(printWriter);
        printWriter.close();
    }

    private File getManifestFile() {
        return new File(this.sketch.getFolder(), MANIFEST_XML);
    }
}

