/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class CheckBoxList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    int checkboxWidth;

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.checkboxWidth = new JCheckBox().getPreferredSize().width;
        this.checkboxWidth += 5;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (CheckBoxList.this.isEnabled() && (n = CheckBoxList.this.locationToIndex(mouseEvent.getPoint())) != -1) {
                    JCheckBox jCheckBox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(n);
                    if (mouseEvent.getX() < CheckBoxList.this.checkboxWidth) {
                        jCheckBox.setSelected(!jCheckBox.isSelected());
                        CheckBoxList.this.repaint();
                    }
                }
            }
        });
        this.setSelectionMode(0);
    }

    protected class CellRenderer
    implements ListCellRenderer {
        protected CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JCheckBox jCheckBox = (JCheckBox)object;
            jCheckBox.setBackground(bl ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            jCheckBox.setForeground(bl ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
            jCheckBox.setEnabled(jList.isEnabled());
            jCheckBox.setFont(CheckBoxList.this.getFont());
            jCheckBox.setFocusPainted(false);
            jCheckBox.setBorderPainted(true);
            jCheckBox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return jCheckBox;
        }
    }
}

