/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.debug.RunnerException;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.app.tools.android.AndroidMode;
import processing.app.tools.android.AndroidSDK;
import processing.app.tools.android.Manifest;
import processing.app.tools.android.Preprocessor;
import processing.core.PApplet;

class Build {
    static final String basePackage = "processing.android.test";
    static final String sdkVersion = "7";
    private final Editor editor;
    private final AndroidSDK sdk;
    Manifest manifest;
    String className;
    File tempBuildFolder;
    File buildFile;
    static final String ICON_72 = "icon-72.png";
    static final String ICON_48 = "icon-48.png";
    static final String ICON_36 = "icon-36.png";

    public Build(Editor editor, AndroidSDK androidSDK) {
        this.editor = editor;
        this.sdk = androidSDK;
    }

    public File createProject(String string) {
        block10: {
            Sketch sketch = this.editor.getSketch();
            try {
                this.tempBuildFolder = this.createTempBuildFolder(sketch);
            }
            catch (IOException iOException) {
                this.editor.statusError(iOException);
                return null;
            }
            File file = new File(this.tempBuildFolder, "src");
            if (Base.DEBUG) {
                Base.openFolder(this.tempBuildFolder);
            }
            try {
                this.manifest = new Manifest(this.editor);
                sketch.prepare();
                Preprocessor preprocessor = new Preprocessor(sketch, this.getPackageName());
                if (!preprocessor.parseSketchSize()) {
                    this.editor.statusError("Could not parse the size() command.");
                    return null;
                }
                this.className = sketch.preprocess(file.getAbsolutePath(), this.manifest.getPackageName(), preprocessor);
                if (this.className == null) break block10;
                File file2 = new File(this.tempBuildFolder, "AndroidManifest.xml");
                this.manifest.writeBuild(file2, this.className, string.equals("debug"));
                this.writeBuildProps(new File(this.tempBuildFolder, "build.properties"));
                this.buildFile = new File(this.tempBuildFolder, "build.xml");
                this.writeBuildXML(this.buildFile, sketch.getName());
                this.writeDefaultProps(new File(this.tempBuildFolder, "default.properties"));
                this.writeLocalProps(new File(this.tempBuildFolder, "local.properties"));
                this.writeRes(new File(this.tempBuildFolder, "res"), this.className);
                File file3 = this.mkdirs(this.tempBuildFolder, "libs");
                File file4 = this.mkdirs(this.tempBuildFolder, "assets");
                InputStream inputStream = PApplet.createInput((File)AndroidMode.getCoreZipLocation());
                PApplet.saveStream((File)new File(file3, "processing-core.jar"), (InputStream)inputStream);
                try {
                    this.writeLibraries(file3, file4);
                    File file5 = sketch.getDataFolder();
                    if (file5.exists()) {
                        Base.copyDir(file5, file4);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RunnerException(iOException.getMessage());
                }
            }
            catch (RunnerException runnerException) {
                this.editor.statusError(runnerException);
                return null;
            }
            catch (IOException iOException) {
                this.editor.statusError(iOException);
                return null;
            }
        }
        return this.tempBuildFolder;
    }

    private File createTempBuildFolder(Sketch sketch) throws IOException {
        File file = File.createTempFile("android", ".pde");
        if (!file.delete() || !file.mkdir()) {
            throw new IOException("Cannot create temp dir " + file + " to build android sketch");
        }
        return file;
    }

    protected File createExportFolder() throws IOException {
        Sketch sketch = this.editor.getSketch();
        File file = new File(sketch.getFolder(), "android");
        if (file.exists()) {
            String string = AndroidMode.getDateStamp(file.lastModified());
            File file2 = new File(sketch.getFolder(), "android." + string);
            boolean bl = file.renameTo(file2);
            if (!bl) {
                ProcessResult processResult;
                try {
                    System.err.println("createProject renameTo() failed, resorting to mv/move instead.");
                    ProcessHelper processHelper = new ProcessHelper("mv", file.getAbsolutePath(), file2.getAbsolutePath());
                    processResult = processHelper.execute();
                }
                catch (IOException iOException) {
                    this.editor.statusError(iOException);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return null;
                }
                if (!processResult.succeeded()) {
                    System.err.println(processResult.getStderr());
                    Base.showWarning("Failed to rename", "Could not rename the old \u201candroid\u201d build folder.\nPlease delete, close, or rename the folder\n" + file.getAbsolutePath() + "\n" + "and try again.", null);
                    Base.openFolder(sketch.getFolder());
                    return null;
                }
            }
        } else {
            boolean bl = file.mkdirs();
            if (!bl) {
                Base.showWarning("Folders, folders, folders", "Could not create the necessary folders to build.\nPerhaps you have some file permissions to sort out?", null);
                return null;
            }
        }
        return file;
    }

    protected boolean antBuild(String string) {
        Project project = new Project();
        String string2 = this.buildFile.getAbsolutePath().replace('\\', '/');
        project.setUserProperty("ant.file", string2);
        project.setUserProperty("build.compiler", "extJavac");
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setErrorPrintStream(System.err);
        defaultLogger.setMessageOutputLevel(0);
        project.addBuildListener((BuildListener)defaultLogger);
        DefaultLogger defaultLogger2 = new DefaultLogger();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        defaultLogger2.setErrorPrintStream(printStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        defaultLogger2.setOutputPrintStream(printStream2);
        defaultLogger2.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)defaultLogger2);
        try {
            this.editor.statusNotice("Building sketch for Android...");
            project.fireBuildStarted();
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)this.buildFile);
            project.executeTarget(string);
            this.editor.statusNotice("Finished building sketch.");
            return true;
        }
        catch (BuildException buildException) {
            String[] stringArray;
            project.fireBuildFinished((Throwable)buildException);
            String string3 = new String(byteArrayOutputStream2.toByteArray());
            for (String string4 : stringArray = string3.split(System.getProperty("line.separator"))) {
                int n;
                int n2 = string4.indexOf("[javac]");
                if (n2 == -1) continue;
                Sketch sketch = this.editor.getSketch();
                int n3 = n2 + "[javac]".length() + 1;
                String[] stringArray2 = PApplet.match((String)string4.substring(n3), (String)"^(.+):([0-9]+):\\s+(.+)$");
                if (stringArray2 == null) continue;
                String string5 = stringArray2[1];
                RunnerException runnerException = sketch.placeException(stringArray2[3], string5 = string5.substring(string5.lastIndexOf(47) + 1), n = PApplet.parseInt((String)stringArray2[2]) - 1);
                if (runnerException == null) continue;
                runnerException.hideStackTrace();
                this.editor.statusError(runnerException);
                return false;
            }
            this.editor.statusError((Exception)((Object)buildException));
            return false;
        }
    }

    protected String getClassName() {
        return this.className;
    }

    String getPathForAPK(String string) {
        Sketch sketch = this.editor.getSketch();
        String string2 = string.equals("release") ? "unsigned" : "debug";
        String string3 = "bin/" + sketch.getName() + "-" + string2 + ".apk";
        File file = new File(this.tempBuildFolder, string3);
        return file.getAbsolutePath();
    }

    private void writeBuildProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("application-package=" + this.getPackageName());
        printWriter.flush();
        printWriter.close();
    }

    private void writeBuildXML(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<project name=\"" + string + "\" default=\"help\">");
        printWriter.println("  <property file=\"local.properties\"/>");
        printWriter.println("  <property file=\"build.properties\"/>");
        printWriter.println("  <property file=\"default.properties\"/>");
        printWriter.println("  <path id=\"android.antlibs\">");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/anttasks.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/sdklib.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/androidprefs.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/apkbuilder.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/jarutils.jar\" />");
        printWriter.println("  </path>");
        printWriter.println("  <taskdef name=\"setup\"");
        printWriter.println("           classname=\"com.android.ant.SetupTask\"");
        printWriter.println("           classpathref=\"android.antlibs\" />");
        printWriter.println("  <setup />");
        printWriter.println("</project>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeDefaultProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("target=Google Inc.:Google APIs:7");
        printWriter.flush();
        printWriter.close();
    }

    private void writeLocalProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        String string = this.sdk.getSdkFolder().getAbsolutePath();
        if (Base.isWindows()) {
            printWriter.println("sdk.dir=" + string.replace('\\', '/'));
        } else {
            printWriter.println("sdk.dir=" + string);
        }
        printWriter.flush();
        printWriter.close();
    }

    private void writeRes(File file, String string) throws RunnerException {
        File file2 = this.mkdirs(file, "layout");
        File file3 = new File(file2, "main.xml");
        this.writeResLayoutMain(file3);
        File file4 = this.editor.getSketch().getFolder();
        File file5 = new File(file4, ICON_36);
        File file6 = new File(file4, ICON_48);
        File file7 = new File(file4, ICON_72);
        File file8 = new File(file, "drawable/icon.png");
        File file9 = new File(file, "drawable-ldpi/icon.png");
        File file10 = new File(file, "drawable-hdpi/icon.png");
        if (!(file5.exists() || file6.exists() || file7.exists())) {
            if (new File(file, "drawable-ldpi").mkdirs()) {
                PApplet.saveStream((File)file9, (InputStream)this.getClass().getResourceAsStream("data/icon-36.png"));
            } else {
                System.err.println("Could not create \"drawable-ldpi\" folder.");
            }
            if (new File(file, "drawable").mkdirs()) {
                PApplet.saveStream((File)file8, (InputStream)this.getClass().getResourceAsStream("data/icon-48.png"));
            } else {
                System.err.println("Could not create \"drawable\" folder.");
            }
            if (new File(file, "drawable-hdpi").mkdirs()) {
                PApplet.saveStream((File)file10, (InputStream)this.getClass().getResourceAsStream("data/icon-72.png"));
            } else {
                System.err.println("Could not create \"drawable-hdpi\" folder.");
            }
        } else {
            try {
                if (file5.exists() && new File(file, "drawable-ldpi").mkdirs()) {
                    Base.copyFile(file5, file9);
                }
                if (file6.exists() && new File(file, "drawable").mkdirs()) {
                    Base.copyFile(file6, file8);
                }
                if (file7.exists() && new File(file, "drawable-hdpi").mkdirs()) {
                    Base.copyFile(file7, file10);
                }
            }
            catch (IOException iOException) {
                System.err.println("Problem while copying icons.");
                iOException.printStackTrace();
            }
        }
    }

    private File mkdirs(File file, String string) throws RunnerException {
        File file2 = new File(file, string);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new RunnerException("Could not create " + file2);
        }
        return file2;
    }

    private void writeResLayoutMain(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<LinearLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        printWriter.println("              android:orientation=\"vertical\"");
        printWriter.println("              android:layout_width=\"fill_parent\"");
        printWriter.println("              android:layout_height=\"fill_parent\">");
        printWriter.println("</LinearLayout>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeLibraries(File file, File file2) throws IOException {
        Object object;
        String string;
        Sketch sketch = this.editor.getSketch();
        for (File[] fileArray : sketch.getImportedLibraries()) {
            File file3 = new File(fileArray.getPath());
            File file4 = new File(file3, "export.txt");
            HashMap<String, String> serializable = Base.readSettings(file4);
            string = serializable.get("android");
            object = null;
            object = string != null ? PApplet.splitTokens((String)string, (String)", ") : file3.list();
            for (int string5 = 0; string5 < ((Object)object).length; ++string5) {
                object[string5] = PApplet.trim((String)object[string5]);
                if (((String)object[string5]).equals("") || ((String)object[string5]).equals(".") || ((String)object[string5]).equals("..")) continue;
                File file5 = new File(file3, (String)object[string5]);
                if (!file5.exists()) {
                    System.err.println("File " + (String)object[string5] + " does not exist");
                    continue;
                }
                if (file5.isDirectory()) {
                    System.err.println("Ignoring sub-folder \"" + (String)object[string5] + "\"");
                    continue;
                }
                String string2 = file5.getName();
                String string3 = string2.toLowerCase();
                if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                    String string4 = string2.substring(0, string2.length() - 4) + ".jar";
                    Base.copyFile(file5, new File(file, string4));
                    continue;
                }
                Base.copyFile(file5, new File(file2, string2));
            }
        }
        File file6 = sketch.getCodeFolder();
        if (file6 != null && file6.exists()) {
            for (File file7 : file6.listFiles()) {
                if (file7.isDirectory() || !((String)(object = (string = file7.getName()).toLowerCase())).endsWith(".jar") && !((String)object).endsWith(".zip")) continue;
                String string5 = string.substring(0, string.length() - 4) + ".jar";
                Base.copyFile(file7, new File(file, string5));
            }
        }
    }

    protected String getPackageName() {
        return this.manifest.getPackageName();
    }

    public void cleanup() {
        this.tempBuildFolder.deleteOnExit();
    }
}

