/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.Editor;
import processing.app.debug.Runner;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.app.tools.android.AVD;
import processing.app.tools.android.AndroidDevice;
import processing.app.tools.android.AndroidEnvironment;
import processing.app.tools.android.AndroidSDK;
import processing.app.tools.android.Build;
import processing.app.tools.android.DeviceListener;
import processing.app.tools.android.IndeterminateProgressMonitor;
import processing.app.tools.android.Keys;
import processing.app.tools.android.Permissions;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidMode
implements DeviceListener {
    private AndroidSDK sdk;
    private Editor editor;
    private Build build;
    private static final String ANDROID_CORE_FILENAME = "processing-android-core-" + Base.VERSION_NAME + ".zip";
    private static final String ANDROID_CORE_URL = "http://processing.googlecode.com/files/" + ANDROID_CORE_FILENAME;
    JCheckBoxMenuItem toggleItem;
    private static File coreZipLocation;
    static final SimpleDateFormat dateFormat;
    private volatile AndroidDevice lastRunDevice = null;
    private static final Pattern LOCATION;
    private static final Pattern EXCEPTION_PARSER;

    public void init(Editor editor, JMenuBar jMenuBar) {
        this.editor = editor;
        JMenu jMenu = new JMenu("Android");
        this.toggleItem = Base.newJCheckBoxMenuItem("Android Mode", 68);
        this.toggleItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AndroidMode.this.updateMode();
            }
        });
        jMenu.add(this.toggleItem);
        JMenuItem jMenuItem = new JMenuItem("Guide");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.openURL("http://wiki.processing.org/w/Android");
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Sketch Permissions");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Permissions(AndroidMode.this.editor);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Signing Key Setup");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Keys(AndroidMode.this.editor);
            }
        });
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Android SDK & AVD Manager");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = AndroidMode.this.sdk.getAndroidTool();
                PApplet.exec((String[])new String[]{file.getAbsolutePath()});
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset Connections");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AndroidEnvironment.killAdbServer();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
    }

    protected void updateMode() {
        boolean bl = this.toggleItem.isSelected();
        if (bl) {
            boolean bl2 = true;
            if (this.sdk == null) {
                bl2 = this.loadAndroid();
            }
            if (bl2) {
                this.editor.setHandlers(new RunHandler(), new PresentHandler(), new StopHandler(), new ExportHandler(), new ExportAppHandler());
                this.build = new Build(this.editor, this.sdk);
                this.editor.statusNotice("Android mode enabled for this editor window.");
            }
        } else {
            this.editor.resetHandlers();
            this.editor.statusNotice("Android mode disabled.");
        }
    }

    protected boolean loadAndroid() {
        this.editor.statusNotice("Loading Android tools.");
        try {
            this.sdk = AndroidSDK.find(this.editor instanceof Frame ? this.editor : null);
        }
        catch (Exception exception) {
            Base.showWarning("Android Tools Error", exception.getMessage(), null);
            this.editor.statusNotice("Android mode canceled.");
            return false;
        }
        if (!this.checkCore()) {
            this.editor.statusNotice("Android mode canceled.");
            return false;
        }
        this.editor.statusNotice("Done loading Android tools.");
        return true;
    }

    protected static File getCoreZipLocation() {
        if (coreZipLocation == null) {
            coreZipLocation = AndroidMode.checkCoreZipLocation();
        }
        return coreZipLocation;
    }

    protected static File checkCoreZipLocation() {
        File file = new File("../../../android/core.zip");
        if (!file.exists() && Base.isMacOS()) {
            file = new File("../../../../../../../android/core.zip");
        }
        if (file.exists()) {
            System.out.println("Using version of core.zip from local SVN checkout.");
            return file;
        }
        return new File(Base.getSketchbookFolder(), ANDROID_CORE_FILENAME);
    }

    private boolean checkCore() {
        File file = AndroidMode.getCoreZipLocation();
        if (!file.exists()) {
            try {
                URL uRL = new URL(ANDROID_CORE_URL);
                PApplet.saveStream((File)file, (InputStream)uRL.openStream());
            }
            catch (Exception exception) {
                Base.showWarning("Download Error", "Could not download Android core.zip", exception);
                return false;
            }
        }
        return true;
    }

    public static String getDateStamp() {
        return dateFormat.format(new Date());
    }

    public static String getDateStamp(long l) {
        return dateFormat.format(new Date(l));
    }

    private boolean startSketch(AndroidDevice androidDevice) {
        String string = this.build.getPackageName();
        String string2 = this.build.getClassName();
        try {
            if (androidDevice.launchApp(string, string2)) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return false;
    }

    private AndroidDevice waitForDevice(Future<AndroidDevice> future, IndeterminateProgressMonitor indeterminateProgressMonitor) throws MonitorCanceled {
        for (int i = 0; i < 120; ++i) {
            if (indeterminateProgressMonitor.isCanceled()) {
                future.cancel(true);
                throw new MonitorCanceled();
            }
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.editor.statusError("Interrupted.");
                return null;
            }
            catch (ExecutionException executionException) {
                this.editor.statusError(executionException);
                return null;
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
        }
        this.editor.statusError("No, on second thought, I'm giving up on waiting for that device to show up.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSketchOnDevice(Future<AndroidDevice> future, String string) throws MonitorCanceled {
        IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor(this.editor, "Building and launching...", "Creating project...");
        try {
            if (this.build.createProject(string) == null) {
                return;
            }
            try {
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                indeterminateProgressMonitor.setNote("Building...");
                if (!this.build.antBuild(string)) {
                    return;
                }
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                indeterminateProgressMonitor.setNote("Waiting for device to become available...");
                AndroidDevice androidDevice = this.waitForDevice(future, indeterminateProgressMonitor);
                if (androidDevice == null || !androidDevice.isAlive()) {
                    this.editor.statusError("Device killed or disconnected.");
                    return;
                }
                androidDevice.addListener(this);
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                indeterminateProgressMonitor.setNote("Installing sketch on " + androidDevice.getId());
                if (!androidDevice.installApp(this.build.getPathForAPK(string), (RunnerListener)((Object)this.editor))) {
                    this.editor.statusError("Device killed or disconnected.");
                    return;
                }
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                indeterminateProgressMonitor.setNote("Starting sketch on " + androidDevice.getId());
                if (this.startSketch(androidDevice)) {
                    this.editor.statusNotice("Sketch launched on the " + (androidDevice.isEmulator() ? "emulator" : "phone") + ".");
                } else {
                    this.editor.statusError("Could not start the sketch.");
                }
                this.lastRunDevice = androidDevice;
            }
            finally {
                this.build.cleanup();
            }
        }
        finally {
            indeterminateProgressMonitor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReleaseForExport(String string) throws MonitorCanceled {
        IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor(this.editor, "Building and exporting...", "Creating project...");
        try {
            File file = this.build.createProject(string);
            if (file == null) {
                return;
            }
            try {
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                indeterminateProgressMonitor.setNote("Building release version...");
                if (indeterminateProgressMonitor.isCanceled()) {
                    throw new MonitorCanceled();
                }
                File file2 = this.build.createExportFolder();
                if (file2 != null) {
                    Base.copyDir(file, file2);
                    this.editor.statusNotice("Done with export.");
                    Base.openFolder(file2);
                } else {
                    this.editor.statusError("Could not copy files to export folder.");
                }
            }
            catch (IOException iOException) {
                this.editor.statusError(iOException);
            }
            finally {
                this.build.cleanup();
            }
        }
        finally {
            indeterminateProgressMonitor.close();
        }
    }

    @Override
    public void stackTrace(List<String> list) {
        Iterator<String> iterator = list.iterator();
        String string = iterator.next();
        Matcher matcher = EXCEPTION_PARSER.matcher(string);
        if (!matcher.matches()) {
            System.err.println("Can't parse this exception line:");
            System.err.println(string);
            this.editor.statusError("Unknown exception");
            return;
        }
        String string2 = matcher.group(1);
        if (Runner.handleCommonErrors(string2, string, (RunnerListener)((Object)this.editor))) {
            return;
        }
        while (iterator.hasNext()) {
            Matcher matcher2;
            String string3 = iterator.next();
            if (!string3.contains("processing.android") || !(matcher2 = LOCATION.matcher(string3)).find()) continue;
            String string4 = matcher2.group(1);
            int n = Integer.parseInt(matcher2.group(2)) - 1;
            RunnerException runnerException = this.editor.getSketch().placeException(string, string4, n);
            this.editor.statusError(runnerException == null ? new RunnerException(string, false) : runnerException);
            return;
        }
    }

    @Override
    public void sketchStopped() {
        this.editor.deactivateRun();
        this.editor.statusEmpty();
    }

    static {
        dateFormat = new SimpleDateFormat("yyMMdd.HHmm");
        LOCATION = Pattern.compile("\\(([^:]+):(\\d+)\\)");
        EXCEPTION_PARSER = Pattern.compile("^\\s*([a-z]+(?:\\.[a-z]+)+)(?:: .+)?$", 2);
    }

    private static class MonitorCanceled
    extends Exception {
        private MonitorCanceled() {
        }
    }

    private class ExportAppHandler
    implements Runnable {
        private ExportAppHandler() {
        }

        public void run() {
            AndroidMode.this.editor.statusError("Export application not yet implemented.");
            AndroidMode.this.editor.deactivateExport();
        }
    }

    private class ExportHandler
    implements Runnable {
        private ExportHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AndroidMode.this.buildReleaseForExport("debug");
            }
            catch (MonitorCanceled monitorCanceled) {
                AndroidMode.this.editor.statusNotice("Canceled.");
            }
            finally {
                AndroidMode.this.editor.deactivateExport();
            }
        }
    }

    private class StopHandler
    implements Runnable {
        private StopHandler() {
        }

        public void run() {
            if (AndroidMode.this.lastRunDevice != null) {
                AndroidMode.this.lastRunDevice.bringLauncherToFront();
            }
        }
    }

    class PresentHandler
    implements Runnable {
        PresentHandler() {
        }

        public void run() {
            try {
                AndroidMode.this.runSketchOnDevice(AndroidEnvironment.getInstance().getHardware(), "debug");
            }
            catch (MonitorCanceled monitorCanceled) {
                AndroidMode.this.sketchStopped();
                AndroidMode.this.editor.statusNotice("Canceled.");
            }
        }
    }

    class RunHandler
    implements Runnable {
        RunHandler() {
        }

        public void run() {
            AVD.ensureEclairAVD(AndroidMode.this.sdk);
            try {
                AndroidMode.this.runSketchOnDevice(AndroidEnvironment.getInstance().getEmulator(), "debug");
            }
            catch (MonitorCanceled monitorCanceled) {
                AndroidMode.this.sketchStopped();
                AndroidMode.this.editor.statusNotice("Canceled.");
            }
        }
    }
}

