/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Sketch;
import processing.app.debug.Compiler;
import processing.core.PApplet;
import processing.core.PConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryFolder
implements PConstants {
    File folder;
    File libraryFolder;
    File examplesFolder;
    String name;
    String author;
    String authorURL;
    String sentence;
    String paragraph;
    int version;
    String prettyVersion;
    HashMap<String, String[]> exportList;
    String[] appletExportList;
    boolean[] multipleArch = new boolean[platformNames.length];
    String nativeLibraryPath;
    static int nativeBits = 32;
    FilenameFilter simpleFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.charAt(0) == '.') {
                return false;
            }
            if (name.equals("CVS")) {
                return false;
            }
            File file = new File(dir, name);
            return !file.isDirectory();
        }
    };
    FilenameFilter jarFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.charAt(0) == '.') {
                return false;
            }
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            String lc = name.toLowerCase();
            return lc.endsWith(".jar") || lc.endsWith(".zip");
        }
    };

    protected static ArrayList<LibraryFolder> list(File folder) throws IOException {
        ArrayList<LibraryFolder> libraries = new ArrayList<LibraryFolder>();
        LibraryFolder.list(folder, libraries);
        return libraries;
    }

    protected static void list(File folder, ArrayList<LibraryFolder> libraries) throws IOException {
        String[] list;
        if (folder.isDirectory() && (list = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.charAt(0) == '.') {
                    return false;
                }
                if (name.equals("CVS")) {
                    return false;
                }
                return new File(dir, name).isDirectory();
            }
        })) != null) {
            Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
            for (String potentialName : list) {
                File baseFolder = new File(folder, potentialName);
                File libraryFolder = new File(baseFolder, "library");
                File libraryJar = new File(libraryFolder, potentialName + ".jar");
                if (!libraryJar.exists()) continue;
                String sanityCheck = Sketch.sanitizeName(potentialName);
                if (sanityCheck.equals(potentialName)) {
                    libraries.add(new LibraryFolder(baseFolder));
                    continue;
                }
                String mess = "The library \"" + potentialName + "\" cannot be used.\n" + "Library names must contain only basic letters and numbers.\n" + "(ASCII only and no spaces, and it cannot start with a number)";
                Base.showMessage("Ignoring bad library name", mess);
            }
        }
    }

    public LibraryFolder(File folder) {
        String[] packages;
        this.folder = folder;
        this.libraryFolder = new File(folder, "library");
        this.examplesFolder = new File(folder, "examples");
        File exportSettings = new File(this.libraryFolder, "export.txt");
        HashMap<String, String> exportTable = Base.readSettings(exportSettings);
        this.name = exportTable.get("name");
        if (this.name == null) {
            this.name = folder.getName();
        }
        this.exportList = new HashMap();
        String[] baseList = folder.list(this.simpleFilter);
        String appletExportStr = exportTable.get("applet");
        this.appletExportList = appletExportStr != null ? PApplet.splitTokens((String)appletExportStr, (String)", ") : baseList;
        File nativeLibraryFolder = this.libraryFolder;
        String hostPlatform = platformNames[PApplet.platform];
        File hostLibrary = new File(this.libraryFolder, hostPlatform);
        if (hostLibrary.exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        if ((hostLibrary = new File(this.libraryFolder, hostPlatform + nativeBits)).exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        this.nativeLibraryPath = nativeLibraryFolder.getAbsolutePath();
        for (int i = 1; i < platformNames.length; ++i) {
            File folder64;
            File folder32;
            File folderAll;
            String[] platformList64;
            String platformName = platformNames[i];
            String platformName32 = platformName + "32";
            String platformName64 = platformName + "64";
            String platformAll = exportTable.get("application." + platformName);
            String[] platformList = platformAll == null ? null : PApplet.splitTokens((String)platformAll, (String)", ");
            String platform32 = exportTable.get("application." + platformName + "32");
            String[] platformList32 = platform32 == null ? null : PApplet.splitTokens((String)platform32, (String)", ");
            String platform64 = exportTable.get("application." + platformName + "64");
            String[] stringArray = platformList64 = platform64 == null ? null : PApplet.splitTokens((String)platform64, (String)", ");
            if (platformAll == null && (folderAll = new File(this.libraryFolder, platformName)).exists()) {
                platformList = PApplet.concat((String[])baseList, (String[])folderAll.list(this.simpleFilter));
            }
            if (platform32 == null && (folder32 = new File(this.libraryFolder, platformName32)).exists()) {
                platformList32 = PApplet.concat((String[])baseList, (String[])folder32.list(this.simpleFilter));
            }
            if (platform64 == null && (folder64 = new File(this.libraryFolder, platformName64)).exists()) {
                platformList64 = PApplet.concat((String[])baseList, (String[])folder64.list(this.simpleFilter));
            }
            if (platformList32 != null || platformList64 != null) {
                this.multipleArch[i] = true;
            }
            if (platformList == null && platformList32 == null && platformList64 == null) {
                this.exportList.put(platformName, baseList);
                continue;
            }
            if (platformList != null) {
                this.exportList.put(platformName, platformList);
            }
            if (platformList32 != null) {
                this.exportList.put(platformName32, platformList32);
            }
            if (platformList64 == null) continue;
            this.exportList.put(platformName64, platformList64);
        }
        for (String pkg : packages = Compiler.packageListFromClassPath(this.getClassPath())) {
            LibraryFolder library = (LibraryFolder)Base.importToLibraryTable.get(pkg);
            if (library != null) {
                System.err.println("The library found in " + this.getPath());
                System.err.println("conflicts with " + library.getPath());
                System.err.println("which already defines the package " + pkg);
                System.err.println();
                continue;
            }
            Base.importToLibraryTable.put(pkg, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.folder.getAbsolutePath();
    }

    public String getLibraryPath() {
        return this.libraryFolder.getAbsolutePath();
    }

    public String getJarPath() {
        return new File(this.folder, "library/" + this.name + ".jar").getAbsolutePath();
    }

    public String getClassPath() {
        String[] jarHeads;
        StringBuilder cp = new StringBuilder();
        for (String jar : jarHeads = this.libraryFolder.list(this.jarFilter)) {
            cp.append(File.pathSeparatorChar);
            cp.append(new File(this.libraryFolder, jar).getAbsolutePath());
        }
        for (String jar : jarHeads = new File(this.nativeLibraryPath).list(this.jarFilter)) {
            cp.append(File.pathSeparatorChar);
            cp.append(new File(this.nativeLibraryPath, jar).getAbsolutePath());
        }
        return cp.toString();
    }

    public String getNativePath() {
        return this.nativeLibraryPath;
    }

    protected File[] wrapFiles(String[] list) {
        File[] outgoing = new File[list.length];
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = new File(this.libraryFolder, list[i]);
        }
        return outgoing;
    }

    public File[] getAppletExports() {
        return this.wrapFiles(this.appletExportList);
    }

    public File[] getApplicationExports(int platform, int bits) {
        String[] list = this.getApplicationExportList(platform, bits);
        return this.wrapFiles(list);
    }

    public String[] getApplicationExportList(int platform, int bits) {
        String[] pieces;
        String platformName = PApplet.platformNames[platform];
        if (bits == 32) {
            String[] pieces2 = this.exportList.get(platformName + "32");
            if (pieces2 != null) {
                return pieces2;
            }
        } else if (bits == 64 && (pieces = this.exportList.get(platformName + "64")) != null) {
            return pieces;
        }
        return this.exportList.get(platformName);
    }

    public boolean hasMultipleArch(int platform) {
        return this.multipleArch[platform];
    }

    static boolean hasMultipleArch(int platform, ArrayList<LibraryFolder> libraries) {
        for (LibraryFolder library : libraries) {
            if (!library.hasMultipleArch(platform)) continue;
            return true;
        }
        return false;
    }

    static {
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
    }
}

