/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.Runner;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.core.PApplet;

public class Commander
implements RunnerListener {
    static final String helpArg = "--help";
    static final String preprocArg = "--preprocess";
    static final String buildArg = "--build";
    static final String runArg = "--run";
    static final String presentArg = "--present";
    static final String sketchArg = "--sketch=";
    static final String outputArg = "--output=";
    static final String exportAppletArg = "--export-applet";
    static final String exportApplicationArg = "--export-application";
    static final String platformArg = "--platform=";
    static final String bitsArg = "--bits=";
    static final String preferencesArg = "--preferences=";
    static final int HELP = -1;
    static final int PREPROCESS = 0;
    static final int BUILD = 1;
    static final int RUN = 2;
    static final int PRESENT = 3;
    static final int EXPORT_APPLET = 4;
    static final int EXPORT_APPLICATION = 5;
    Sketch sketch;

    public static void main(String[] args) {
        Base.setCommandLine();
        Base.initPlatform();
        Base.initRequirements();
        new Commander(args);
    }

    public Commander(String[] args) {
        File outputFolder;
        String sketchFolder = null;
        String pdePath = null;
        String outputPath = null;
        String preferencesPath = null;
        int platformIndex = PApplet.platform;
        int platformBits = 0;
        int mode = -1;
        for (String arg : args) {
            if (arg.length() == 0 || arg.equals(helpArg)) continue;
            if (arg.equals(buildArg)) {
                mode = 1;
                continue;
            }
            if (arg.equals(runArg)) {
                mode = 2;
                continue;
            }
            if (arg.equals(presentArg)) {
                mode = 3;
                continue;
            }
            if (arg.equals(preprocArg)) {
                mode = 0;
                continue;
            }
            if (arg.equals(exportAppletArg)) {
                mode = 4;
                continue;
            }
            if (arg.equals(exportApplicationArg)) {
                mode = 5;
                continue;
            }
            if (arg.startsWith(platformArg)) {
                String platformStr = arg.substring(platformArg.length());
                platformIndex = Base.getPlatformIndex(platformStr);
                if (platformIndex != -1) continue;
                Commander.complainAndQuit(platformStr + " should instead be " + "'windows', 'macosx', or 'linux'.");
                continue;
            }
            if (arg.startsWith(sketchArg)) {
                sketchFolder = arg.substring(sketchArg.length());
                File sketchy = new File(sketchFolder);
                File pdeFile = new File(sketchy, sketchy.getName() + ".pde");
                pdePath = pdeFile.getAbsolutePath();
                continue;
            }
            if (arg.startsWith(preferencesArg)) {
                preferencesPath = arg.substring(preferencesArg.length());
                continue;
            }
            if (arg.startsWith(outputArg)) {
                outputPath = arg.substring(outputArg.length());
                continue;
            }
            Commander.complainAndQuit("I don't know anything about " + arg + ".");
        }
        if (outputPath == null && (mode == 0 || mode == 1 || mode == 2 || mode == 3)) {
            Commander.complainAndQuit("An output path must be specified when using --preprocess, --build, --run, or --present.");
        }
        if (mode == -1) {
            Commander.printCommandLine(System.out);
            System.exit(0);
        }
        if (!(outputFolder = new File(outputPath)).exists() && !outputFolder.mkdirs()) {
            Commander.complainAndQuit("Could not create the output folder.");
        }
        Preferences.init(preferencesPath);
        if (sketchFolder == null) {
            Commander.complainAndQuit("No sketch path specified.");
        } else if (outputPath.equals(pdePath)) {
            Commander.complainAndQuit("The sketch path and output path cannot be identical.");
        } else if (!pdePath.toLowerCase().endsWith(".pde")) {
            Commander.complainAndQuit("Sketch path must point to the main .pde file.");
        } else {
            boolean success = false;
            try {
                this.sketch = new Sketch(null, pdePath);
                if (mode == 0) {
                    success = this.sketch.preprocess(outputPath) != null;
                } else if (mode == 1) {
                    success = this.sketch.build(outputPath) != null;
                } else if (mode == 2 || mode == 3) {
                    String className = this.sketch.build(outputPath);
                    if (className != null) {
                        success = true;
                        Runner runner = new Runner(this, this.sketch);
                        runner.launch(className, mode == 3);
                    } else {
                        success = false;
                    }
                } else if (mode == 4) {
                    if (outputPath != null) {
                        success = this.sketch.exportApplet(outputPath);
                    } else {
                        String target = sketchFolder + File.separatorChar + "applet";
                        success = this.sketch.exportApplet(target);
                    }
                } else if (mode == 5) {
                    if (outputPath != null) {
                        success = this.sketch.exportApplication(outputPath, platformIndex, platformBits);
                    } else {
                        outputPath = sketchFolder + File.separatorChar + "application." + Base.getPlatformName(platformIndex);
                        success = this.sketch.exportApplication(outputPath, platformIndex, platformBits);
                    }
                }
                System.exit(success ? 0 : 1);
            }
            catch (RunnerException re) {
                this.statusError(re);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void statusNotice(String message) {
        System.err.println(message);
    }

    public void statusError(String message) {
        System.err.println(message);
    }

    public void statusError(Exception exception) {
        if (exception instanceof RunnerException) {
            RunnerException re = (RunnerException)exception;
            String filename = this.sketch.getCode(re.getCodeIndex()).getFileName();
            int line = re.getCodeLine();
            int column = re.getCodeColumn();
            if (column == -1) {
                column = 0;
            }
            System.err.println(filename + ":" + line + ":" + column + ":" + line + ":" + column + ":" + " " + re.getMessage());
        } else {
            exception.printStackTrace();
        }
    }

    static void complainAndQuit(String lastWords) {
        Commander.printCommandLine(System.err);
        System.err.println(lastWords);
        System.exit(1);
    }

    static void printCommandLine(PrintStream out) {
        out.println("Processing " + Base.VERSION_NAME + " rocks the console.");
        out.println();
        out.println("--help               Show this help text.");
        out.println();
        out.println("--sketch=<name>      Specify the sketch folder (required)");
        out.println("--output=<name>      Specify the output folder (required and");
        out.println("                     cannot be the same as the sketch folder.)");
        out.println();
        out.println("--preprocess         Preprocess a sketch into .java files.");
        out.println("--build              Preprocess and compile a sketch into .class files.");
        out.println("--run                Preprocess, compile, and run a sketch.");
        out.println("--present            Preprocess, compile, and run a sketch full screen.");
        out.println();
        out.println("--export-applet      Export an applet.");
        out.println("--export-application Export an application.");
        out.println("--platform           Specify the platform (export to application only).");
        out.println("                     Should be one of 'windows', 'macosx', or 'linux'.");
        out.println("--bits               Must be specified if libraries are used that are");
        out.println("                     32- or 64-bit specific such as the OpenGL library.");
        out.println("                     Otherwise specify 0 or leave it out.");
        out.println();
        out.println("--preferences=<file> Specify a preferences file to use. Required if the");
        out.println("                     sketch uses libraries found in your sketchbook folder.");
    }
}

